/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler;

import com.ebmwebsourcing.easybpel.extended.service.activity.impl.ExtendedActivityServiceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Empty;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Exit;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ForEach;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.If;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ReThrow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.RepeatUntil;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Throw;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Wait;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.While;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.FromAndTo;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtendedActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.BPELCompiler;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.CatchAll;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TAssign;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCopy;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFrom;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInitiate;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TTo;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.AssignImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ForEachImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.FromImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.ToImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.VariablePropertyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.BuiltInException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.UserDefinedException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELAssigner;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELCorrelationMatcher;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELFaultHandler;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.BPELMessageMatcher;
import com.ebmwebsourcing.easybpel.model.bpel.impl.runtime.protocol.SOAPAdapter;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELElementVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELIntVariableImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELBooleanExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELAssignementExpressionImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.function.DoXslTransformFunctionImpl;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.Transition;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SenderBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.DateExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.LongExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.AbstractCompiler;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.Correlation;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.AssignBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ExitBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReThrowBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.SenderBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ThrowBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.WaitBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.fault.FaultImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.soa.EndpointImpl;
import com.ebmwebsourcing.easyviper.core.impl.soa.correlation.CorrelationGroupImpl;
import com.ebmwebsourcing.easyviper.core.impl.soa.correlation.CorrelationImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Property;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PropertyAlias;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.schema.DefaultSchema;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLElement;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="service", signature=BPELCompiler.class)})
@Membrane(controller="primitive")
public class BPELCompilerImpl
extends AbstractCompiler<BPELProcess>
implements BPELCompiler {
    private static final long serialVersionUID = 1L;
    BPELReader reader;
    DefaultSchema defaultSchema = null;
    DocumentBuilderFactory factory;
    private Logger log = Logger.getLogger(BPELCompilerImpl.class.getName());

    public BPELCompilerImpl() throws BPELException {
        this.reader = BPELFactoryImpl.getInstance().newBPELReader();
        this.defaultSchema = SchemaFactory.getDefaultSchema();
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String convertStreamToString(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        try {
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(String.valueOf(string) + "\n");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException iOException) {
            iOException.printStackTrace();
            return stringBuilder.toString();
        }
        inputStream.close();
        return stringBuilder.toString();
    }

    @Override
    public BPELProcess validate(URI uRI) throws CoreException {
        BPELProcess bPELProcess = null;
        try {
            ExtendedActivityServiceImpl extendedActivityServiceImpl;
            BPELStaticAnalysisImpl.getInstance().getErrors().clear();
            BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
            BPELStaticAnalysisImpl.getInstance().getInfos().clear();
            URL uRL = null;
            InputStream inputStream = null;
            if (uRI.isAbsolute()) {
                inputStream = uRI.toURL().openStream();
                uRL = uRI.toURL();
            } else {
                uRL = new URL(new File(".").toURL(), uRI.toString());
                inputStream = new FileInputStream(new File(uRL.toURI()));
            }
            Document document = this.factory.newDocumentBuilder().parse(inputStream);
            Document document2 = DoXslTransformFunctionImpl.process(Thread.currentThread().getContextClassLoader().getResource("xslt/upperYesAndNoAttribute.xsl"), document, null);
            if (document2.getDocumentURI() == null) {
                document2.setDocumentURI(uRL.getPath());
            }
            if ((bPELProcess = this.reader.readBPEL(document2)).getExtensions() != null && bPELProcess.getExtensions().getExtensions() != null && bPELProcess.getExtensions().getExtensions().size() > 0 && (extendedActivityServiceImpl = this.getModel().getCore().getEngine().getServiceManager().getService(ExtendedActivityServiceImpl.class)) == null) {
                throw new CoreException("Sorry, but the extended Service Manager is not plugged to engine!!!");
            }
        }
        catch (BPELException bPELException) {
            throw new CoreException(bPELException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CoreException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new CoreException(iOException);
        }
        catch (SAXException sAXException) {
            throw new CoreException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CoreException(parserConfigurationException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CoreException(uRISyntaxException);
        }
        return bPELProcess;
    }

    @Override
    public Process generate(Core core, BPELProcess bPELProcess) throws BPELException {
        Process process = null;
        if (core == null) {
            throw new BPELException("Core MUST not be null");
        }
        try {
            process = this.compile(bPELProcess);
        }
        catch (CoreException coreException) {
            throw new BPELException(coreException);
        }
        return process;
    }

    @Override
    public Process compile(BPELProcess bPELProcess) throws CoreException {
        Process process = null;
        try {
            if (bPELProcess == null) {
                throw new CoreException("bpel process cannot be null !!!");
            }
            this.log.finest("start the compilation");
            process = this.getModel().getCore().getEngine().createNewEmptyProcessInstance(new QName(bPELProcess.getQName() + "_" + System.nanoTime()), bPELProcess);
            BPELAssigner bPELAssigner = new BPELAssigner(bPELProcess);
            bPELAssigner.setLog(this.log);
            process.setAssigner(bPELAssigner);
            this.log.finest("empty process create");
            Node node = null;
            this.affectVariablesInScope(bPELProcess, bPELProcess, process);
            for (PartnerLink partnerLink : bPELProcess.getPartnerLinks()) {
                process.getEndpoints().put(partnerLink, new EndpointImpl());
            }
            if (bPELProcess.getActivity() != null) {
                node = this.generateActivity(process, bPELProcess.getActivity(), bPELProcess);
            }
            if (bPELProcess.getFaultHandlers() != null) {
                this.generateFaultHandlers(process, bPELProcess.getFaultHandlers().getCatchs(), bPELProcess.getFaultHandlers().getCatchAll(), bPELProcess);
            }
            if (node == null) {
                throw new CoreException("No main in BPEL process");
            }
            process.setInitialNode(node);
            this.log.finest("end of the compilation");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        return process;
    }

    private void affectVariablesInScope(BPELProcess bPELProcess, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope scope, Scope scope2) throws BPELException {
        BPELMessageMatcher bPELMessageMatcher = new BPELMessageMatcher(bPELProcess.getImports());
        if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
            bPELMessageMatcher.setLog(this.log);
        }
        for (BPELVariable bPELVariable : scope.getVariables()) {
            this.addVariableInScope(scope2, bPELVariable);
        }
    }

    private BPELVariable addVariableInScope(Scope scope, BPELVariable bPELVariable) throws BPELException {
        BPELVariable bPELVariable2 = (BPELVariable)bPELVariable.copypaste();
        scope.getVariables().put(bPELVariable2.getQName(), bPELVariable2);
        return bPELVariable2;
    }

    private Node generateSequence(Scope scope, Sequence sequence, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate sequence");
        Node node = null;
        if (sequence != null) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Node node2 = null;
            for (Activity activity : sequence.getActivities()) {
                node2 = this.generateActivity(scope, activity, bPELProcess);
                if (node2 != null) {
                    arrayList.add(node2);
                    continue;
                }
                throw new CoreException("Impossible to generate activity: " + activity.getName());
            }
            node = CreationPatternFactory.getInstance().createSequencePattern(sequence.getName(), arrayList, scope, null);
        }
        this.log.finest("end generate sequence");
        return node;
    }

    private Node generateFlow(Scope scope, Flow flow, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate flow");
        Node node = null;
        if (flow != null) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Node node2 = null;
            for (Activity activity : flow.getActivities()) {
                node2 = this.generateActivity(scope, activity, bPELProcess);
                if (node2 != null) {
                    arrayList.add(node2);
                    continue;
                }
                throw new CoreException("Impossible to generate activity: " + activity.getName());
            }
            node = CreationPatternFactory.getInstance().createForkPattern(flow.getName(), arrayList, scope);
        }
        this.log.finest("end generate flow");
        return node;
    }

    private Node generateIf(Scope scope, If if_, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate if");
        Node node = null;
        if (if_ != null) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Node node2 = null;
            ArrayList<ConditionalExpression> arrayList2 = new ArrayList<ConditionalExpression>();
            for (BPELBooleanExpression object : if_.getConditions()) {
                BPELBooleanExpression bPELBooleanExpression = (BPELBooleanExpression)object.copypaste();
                if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                    bPELBooleanExpression.setLog(this.log);
                }
                arrayList2.add(bPELBooleanExpression);
            }
            for (Activity activity : if_.getActivities()) {
                node2 = this.generateActivity(scope, activity, bPELProcess);
                if (node2 != null) {
                    arrayList.add(node2);
                    continue;
                }
                throw new CoreException("Impossible to generate activity: " + activity + " in if => " + if_.getName());
            }
            node = CreationPatternFactory.getInstance().createIfPattern(if_.getName(), arrayList2, arrayList, scope);
        }
        this.log.finest("end generate if");
        return node;
    }

    private Node generatePick(Scope scope, Pick pick, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate pick");
        Node node = null;
        if (pick != null) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Node node2 = null;
            ArrayList<ReceiverBehaviour> arrayList2 = new ArrayList<ReceiverBehaviour>();
            BPELMessageMatcher bPELMessageMatcher = new BPELMessageMatcher(bPELProcess.getImports());
            for (OnMessage onMessage : pick.getOnMessages()) {
                if (onMessage.getActivity() == null) continue;
                ReceiverBehaviourImpl receiverBehaviourImpl = new ReceiverBehaviourImpl();
                receiverBehaviourImpl.addVariableName(new QName(onMessage.getInputVariable()));
                if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                    bPELMessageMatcher.setLog(this.log);
                }
                receiverBehaviourImpl.setMessageMatcher(bPELMessageMatcher);
                if (!pick.getCreateInstance()) {
                    BPELCorrelationMatcher bPELCorrelationMatcher = new BPELCorrelationMatcher(bPELProcess, onMessage.getCorrelations(), new QName(onMessage.getInputVariable()));
                    if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                        bPELCorrelationMatcher.setLog(this.log);
                    }
                    ArrayList<CorrelationMatcher> arrayList3 = new ArrayList<CorrelationMatcher>();
                    arrayList3.add(bPELCorrelationMatcher);
                    receiverBehaviourImpl.setCorrelationsMatchers(arrayList3);
                }
                arrayList2.add(receiverBehaviourImpl);
                node2 = this.generateActivity(scope, onMessage.getActivity(), bPELProcess);
                if (node2 != null) {
                    arrayList.add(node2);
                    continue;
                }
                throw new CoreException("Impossible to generate activity: " + onMessage.getActivity());
            }
            node = CreationPatternFactory.getInstance().createSeveralReceiversPattern(pick.getName(), arrayList2, arrayList, scope);
        }
        this.log.finest("end generate pick");
        return node;
    }

    private Node generateWhile(Scope scope, While while_, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate while");
        Node node = null;
        if (while_ != null) {
            BPELBooleanExpression bPELBooleanExpression = (BPELBooleanExpression)while_.getCondition().copypaste();
            if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                bPELBooleanExpression.setLog(this.log);
            }
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Node node2 = null;
            node2 = this.generateActivity(scope, while_.getActivity(), bPELProcess);
            if (node2 == null) {
                throw new CoreException("Impossible to generate activity: " + while_.getActivity());
            }
            arrayList.add(node2);
            node = CreationPatternFactory.getInstance().createLoopPattern(while_.getName(), bPELBooleanExpression, true, arrayList, scope, null);
        }
        this.log.finest("end generate while");
        return node;
    }

    private Node generateRepeatUntil(Scope scope, RepeatUntil repeatUntil, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate repeat until");
        Node node = null;
        if (repeatUntil != null) {
            BPELBooleanExpression bPELBooleanExpression = (BPELBooleanExpression)repeatUntil.getCondition().copypaste();
            if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                bPELBooleanExpression.setLog(this.log);
            }
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Node node2 = null;
            node2 = this.generateActivity(scope, repeatUntil.getActivity(), bPELProcess);
            if (node2 == null) {
                throw new CoreException("Impossible to generate activity: " + repeatUntil.getActivity());
            }
            arrayList.add(node2);
            node = CreationPatternFactory.getInstance().createLoopPattern(repeatUntil.getName(), bPELBooleanExpression, false, arrayList, scope, null);
        }
        this.log.finest("end generate repeat until");
        return node;
    }

    private Node generateForEach(Scope scope, ForEach forEach, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate forEach");
        Node node = null;
        try {
            if (forEach != null) {
                Logger logger = null;
                if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                    logger = this.log;
                }
                BPELBooleanExpression bPELBooleanExpression = ForEachImpl.createBooleanExpressionFromStartAndFinalCounterValue(forEach, bPELProcess, logger);
                ArrayList<Node> arrayList = new ArrayList<Node>();
                Node node2 = null;
                node = CreationPatternFactory.getInstance().createScopePattern("topScope4foarEach_" + forEach.getName() + "_" + UUID.randomUUID(), scope);
                Scope scope2 = (Scope)node.getComponent().getFcInterface("scope");
                Schema schema = SchemaFactory.newInstance().newSchema();
                schema.setTargetNamespace(bPELProcess.getTargetNamespace());
                Element element = (Element)schema.createElement();
                element.setQName(new QName(schema.getTargetNamespace(), forEach.getCounterName()));
                element.setType(SchemaFactory.getDefaultSchema().getTypeInt());
                schema.addElement(element);
                bPELProcess.getImports().getSchemas().add(schema);
                TVariable tVariable = new TVariable();
                tVariable.setName(element.getQName().getLocalPart());
                tVariable.setElement(element.getQName());
                tVariable.setType(((Type)element.getType()).getQName());
                BPELIntVariableImpl bPELIntVariableImpl = new BPELIntVariableImpl(tVariable, null, (BPELElement)forEach);
                scope2.getVariables().put(bPELIntVariableImpl.getQName(), bPELIntVariableImpl);
                TAssign tAssign = new TAssign();
                tAssign.setName("AssignI");
                TCopy tCopy = new TCopy();
                tAssign.getCopyOrExtensionAssignOperation().add(tCopy);
                TFrom tFrom = new TFrom();
                tCopy.setFrom(tFrom);
                TTo tTo = new TTo();
                tCopy.setTo(tTo);
                tFrom.getContent().add(forEach.getStartCounterValue().getContent());
                tFrom.setExpressionLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
                tTo.getContent().add("$" + forEach.getCounterName());
                tTo.setExpressionLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
                AssignImpl assignImpl = new AssignImpl(tAssign, null);
                Node node3 = this.generateAssign(scope2, assignImpl, bPELProcess);
                scope2.setInitialNode(node3);
                if (forEach.getScope().getName() == null) {
                    forEach.getScope().setName("underScopeInForEach_" + forEach.getName() + "_" + UUID.randomUUID());
                }
                if ((node2 = this.generateScope(scope2, forEach.getScope(), bPELProcess)) == null) {
                    throw new CoreException("Impossible to generate activity: " + forEach.getScope());
                }
                arrayList.add(node2);
                TAssign tAssign2 = new TAssign();
                tAssign2.setName("AssignE");
                TCopy tCopy2 = new TCopy();
                tAssign2.getCopyOrExtensionAssignOperation().add(tCopy2);
                TFrom tFrom2 = new TFrom();
                tCopy2.setFrom(tFrom2);
                TTo tTo2 = new TTo();
                tCopy2.setTo(tTo2);
                tFrom2.getContent().add("$" + forEach.getCounterName() + " + 1");
                tFrom2.setExpressionLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
                tTo2.getContent().add("$" + forEach.getCounterName());
                tTo2.setExpressionLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
                AssignImpl assignImpl2 = new AssignImpl(tAssign2, null);
                Node node4 = this.generateAssign(scope2, assignImpl2, bPELProcess);
                arrayList.add(node4);
                Node node5 = CreationPatternFactory.getInstance().createLoopPattern(forEach.getName(), bPELBooleanExpression, true, arrayList, scope2, null);
                Transition transition = scope2.createTransition("AssignI2" + forEach.getName(), null);
                scope2.linked(node3, transition, node5);
            }
            this.log.finest("end generate foreach");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        catch (BPELException bPELException) {
            throw new CoreException(bPELException);
        }
        catch (SchemaException schemaException) {
            throw new CoreException(schemaException);
        }
        return node;
    }

    private Node generateScope(Scope scope, com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope scope2, BPELProcess bPELProcess) throws CoreException {
        try {
            Node node = null;
            node = CreationPatternFactory.getInstance().createScopePattern(scope2.getName(), scope);
            Scope scope3 = (Scope)node.getComponent().getFcInterface("scope");
            this.affectVariablesInScope(bPELProcess, scope2, scope3);
            for (Serializable serializable : scope2.getPartnerLinks()) {
                scope.getEndpoints().put(serializable, new EndpointImpl());
            }
            if (scope2.getActivity() != null) {
                Serializable serializable;
                serializable = this.generateActivity(scope3, scope2.getActivity(), bPELProcess);
                scope3.setInitialNode((Node)serializable);
            }
            if (scope2.getFaultHandlers() != null) {
                this.generateFaultHandlers(scope3, scope2.getFaultHandlers().getCatchs(), scope2.getFaultHandlers().getCatchAll(), bPELProcess);
            }
            return node;
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
    }

    private Node generateInvoke(Scope scope, Invoke invoke, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate invoke");
        Node node = null;
        Node node2 = null;
        try {
            WSDLElement wSDLElement;
            WSDLElement wSDLElement2;
            if (invoke == null) {
                throw new CoreException("Invoke cannot be null");
            }
            node = CreationPatternFactory.getInstance().createScopePattern("scopeOf_" + invoke.getName(), scope);
            Scope scope2 = (Scope)node.getComponent().getFcInterface("scope");
            SenderBehaviourImpl senderBehaviourImpl = new SenderBehaviourImpl();
            senderBehaviourImpl.setKind(SenderBehaviour.Kind.ASYNCHRONOUS);
            if (invoke.getOutputVariable() != null) {
                senderBehaviourImpl.setKind(SenderBehaviour.Kind.SYNCHRONOUS);
            }
            senderBehaviourImpl.setInputVariableName(new QName(invoke.getInputVariable()));
            if (invoke.getOutputVariable() != null) {
                senderBehaviourImpl.setOutputVariableName(new QName(invoke.getOutputVariable()));
            }
            senderBehaviourImpl.setFaultHandler(new BPELFaultHandler(bPELProcess, invoke));
            PartnerLink partnerLink = bPELProcess.getPartnerLink(invoke.getPartnerLink());
            if (partnerLink == null) {
                throw new CoreException("Impossible to find partner with name: " + invoke.getPartnerLink());
            }
            Endpoint endpoint = scope.findEndpoint(partnerLink);
            SOAPAdapter sOAPAdapter = new SOAPAdapter(bPELProcess, endpoint);
            if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                sOAPAdapter.setLog(this.log);
            }
            senderBehaviourImpl.setMessageAdapter(sOAPAdapter);
            endpoint.setInterfaceName(invoke.getInterface());
            if (endpoint.getInterfaceName() == null) {
                wSDLElement2 = bPELProcess.getImports().getPartnerLinkType(partnerLink.getPartnerLinkType());
                if (wSDLElement2 == null) {
                    throw new CoreException("Impossible to find partner link type with name: " + partnerLink.getPartnerLinkType());
                }
                wSDLElement = wSDLElement2.getRole(partnerLink.getPartnerRole());
                if (wSDLElement == null) {
                    throw new CoreException("Impossible to find role with name: " + partnerLink.getPartnerRole());
                }
                endpoint.setInterfaceName(wSDLElement.getInterface().getQName());
            }
            if (endpoint.getInterfaceName() == null) {
                throw new CoreException("Impossible to find interface to invoke");
            }
            wSDLElement2 = (InterfaceType)bPELProcess.getImports().getInterface(endpoint.getInterfaceName());
            if (wSDLElement2 == null) {
                throw new CoreException("Impossible to find this interface: " + endpoint.getInterfaceName());
            }
            wSDLElement = bPELProcess.getImports().getDescriptionByInterface(wSDLElement2.getQName());
            AbsItfDescription absItfDescription = null;
            List list = bPELProcess.getImports().findEndpointsImplementingInterface(wSDLElement2);
            if (list != null && list.size() > 0) {
                endpoint.setEndpointName(((org.ow2.easywsdl.wsdl.api.Endpoint)list.get(0)).getName());
                endpoint.setServiceName(((Service)((org.ow2.easywsdl.wsdl.api.Endpoint)list.get(0)).getService()).getQName());
                absItfDescription = bPELProcess.getImports().getDescriptionByService(((Service)((org.ow2.easywsdl.wsdl.api.Endpoint)list.get(0)).getService()).getQName());
            }
            if (absItfDescription != null) {
                endpoint.setDescription(absItfDescription);
            } else {
                endpoint.setDescription(wSDLElement);
            }
            senderBehaviourImpl.setOperationName(invoke.getOperation());
            senderBehaviourImpl.setProviderEndpointKey(partnerLink);
            node2 = scope2.createNode(invoke.getName(), senderBehaviourImpl);
            scope.getEndpoints().put(partnerLink, endpoint);
            this.initiateCorrelations(scope, invoke.getCorrelations(), invoke.getInputVariable(), bPELProcess);
            scope2.setInitialNode(node2);
            this.generateFaultHandlers(scope2, invoke.getCatchs(), invoke.getCatchAll(), bPELProcess);
        }
        catch (WSDL4BPELException wSDL4BPELException) {
            throw new CoreException(wSDL4BPELException);
        }
        catch (BPELException bPELException) {
            throw new CoreException(bPELException);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        this.log.finest("end generate invoke");
        return node;
    }

    private void generateFaultHandlers(Scope scope, List<Catch> list, CatchAll catchAll, BPELProcess bPELProcess) throws BPELException, CoreException, NoSuchInterfaceException {
        Node node;
        Object object;
        this.log.finest("start generate generateFaultHandlers");
        for (Catch serializable : list) {
            Object object2;
            object = CreationPatternFactory.getInstance().createScopePattern("catchScopeOf_" + serializable.getFaultName(), scope);
            node = (Scope)object.getComponent().getFcInterface("scope");
            FaultImpl faultImpl = new FaultImpl();
            if (serializable.getFaultName() != null) {
                faultImpl.setFaultName(serializable.getFaultName());
            } else {
                faultImpl.setFaultName(new QName("unknown"));
            }
            BPELVariable bPELVariable = null;
            if (serializable.getFaultVariable() != null) {
                bPELVariable = (BPELVariable)scope.findVariable(new QName(serializable.getFaultVariable()));
            }
            if (bPELVariable == null && serializable.getFaultVariable() != null) {
                object2 = new TVariable();
                ((TVariable)object2).setElement(serializable.getFaultElement());
                ((TVariable)object2).setMessageType(serializable.getFaultMessageType());
                ((TVariable)object2).setName(serializable.getFaultVariable());
                bPELVariable = new BPELElementVariableImpl((TVariable)object2, null, (BPELElement)serializable);
                this.addVariableInScope((Scope)node, bPELVariable);
            }
            faultImpl.setVariable(bPELVariable);
            faultImpl.setFaultHandler(new BPELFaultHandler(bPELProcess, null));
            scope.getExceptions().put(faultImpl, (Scope)node);
            object2 = this.generateActivity((Scope)node, serializable.getActivity(), bPELProcess);
            node.setInitialNode((Node)object2);
        }
        if (catchAll != null) {
            Node node2 = CreationPatternFactory.getInstance().createScopePattern("catchScopeOf_catchAll", scope);
            Scope scope2 = (Scope)node2.getComponent().getFcInterface("scope");
            object = new FaultImpl();
            object.setFaultName(new QName("unknown"));
            object.setFaultHandler(new BPELFaultHandler(bPELProcess, null));
            scope.getExceptions().put((Fault)object, scope2);
            node = this.generateActivity(scope2, catchAll.getActivity(), bPELProcess);
            scope2.setInitialNode(node);
        }
        this.log.finest("end generate generateFaultHandlers");
    }

    private void initiateCorrelations(Scope scope, List<com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation> list, String string, BPELProcess bPELProcess) throws BPELException {
        try {
            if (list != null && list.size() > 0) {
                this.log.finest("number of correlations defined in this activity: " + list.size());
                for (com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation correlation : list) {
                    if (!correlation.getInitiate().equals((Object)TInitiate.YES) && !correlation.getInitiate().equals((Object)TInitiate.JOIN)) continue;
                    if (scope.findCorrelationGroups(correlation.getSet()).size() == 0) {
                        CorrelationSet correlationSet = bPELProcess.getCorrelationSet(correlation.getSet());
                        if (correlationSet == null) {
                            throw new BPELException("Impossible to find the correlation set corresponding to this name " + correlation.getSet());
                        }
                        Variable variable = scope.findVariable(new QName(string));
                        BPELVariable bPELVariable = (BPELVariable)variable;
                        if (variable == null) {
                            throw new BPELException("Impossible to find variable corresponding to this name " + string);
                        }
                        CorrelationGroupImpl correlationGroupImpl = new CorrelationGroupImpl();
                        HashMap<String, Correlation> hashMap = new HashMap<String, Correlation>();
                        correlationGroupImpl.setCorrelations(hashMap);
                        List<QName> list2 = correlationSet.getProperties();
                        for (QName qName : list2) {
                            Property property = bPELProcess.getImports().getProperty(qName);
                            if (property == null) {
                                throw new BPELException("Impossible to find property corresponding to this name " + qName);
                            }
                            List<PropertyAlias> list3 = bPELProcess.getImports().getPropertyAliases4ThisProperty(property.getQName());
                            if (list3 == null) continue;
                            for (PropertyAlias propertyAlias : list3) {
                                boolean bl = false;
                                if (propertyAlias.getElement() != null && propertyAlias.getElement().equals(bPELVariable.getElement())) {
                                    bl = true;
                                } else if (propertyAlias.getMessageType() != null && propertyAlias.getMessageType().equals(bPELVariable.getMessageType())) {
                                    bl = true;
                                } else if (propertyAlias.getType() != null && propertyAlias.getType().equals(bPELVariable.getTypeQName())) {
                                    bl = true;
                                }
                                if (!bl) continue;
                                ToImpl toImpl = new ToImpl(new TTo(), null);
                                toImpl.setKind(FromAndTo.Kind.VARIABLE_PROPERTY);
                                toImpl.setVariableProperty(new VariablePropertyImpl(string, property.getQName()));
                                FromImpl fromImpl = new FromImpl(new TFrom(), null);
                                fromImpl.setKind(FromAndTo.Kind.VARIABLE_PROPERTY);
                                CorrelationImpl correlationImpl = new CorrelationImpl();
                                correlationImpl.setName(correlation.getSet());
                                correlationImpl.setOrignator(toImpl);
                                correlationImpl.setFollower(fromImpl);
                                hashMap.put(correlationImpl.getName(), correlationImpl);
                            }
                        }
                        if (hashMap.size() > 0) {
                            scope.getProcess().getCorrelationGroups().add(correlationGroupImpl);
                        }
                        this.log.finest("Correlation " + correlation.getSet() + " created and added to scope: " + scope.getProcess().getName());
                        continue;
                    }
                    this.log.finest("Correlation " + correlation.getSet() + " already created");
                }
            }
        }
        catch (WSDL4BPELException wSDL4BPELException) {
            throw new BPELException(wSDL4BPELException);
        }
        catch (CoreException coreException) {
            throw new BPELException(coreException);
        }
    }

    private Node generateReply(Scope scope, Reply reply, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate reply");
        Node node = null;
        try {
            if (reply != null) {
                SenderBehaviourImpl senderBehaviourImpl = new SenderBehaviourImpl();
                senderBehaviourImpl.setKind(SenderBehaviour.Kind.ASYNCHRONOUS);
                senderBehaviourImpl.setInputVariableName(new QName(reply.getOutputVariable()));
                EndpointImpl endpointImpl = new EndpointImpl();
                endpointImpl.setEndpointName("client");
                InterfaceType interfaceType = null;
                if (reply.getInterface() != null && (interfaceType = (InterfaceType)bPELProcess.getImports().getInterface(reply.getInterface())) == null) {
                    throw new CoreException("Impossible to find interface corresponding to " + reply.getInterface());
                }
                endpointImpl.setInterfaceName(reply.getInterface());
                endpointImpl.setInvokedOperation(reply.getOperation());
                endpointImpl.setServiceName(new QName("client"));
                if (interfaceType != null) {
                    endpointImpl.setDescription(((AbstractWSDLElementImpl)((Object)interfaceType)).getTopParent());
                }
                senderBehaviourImpl.setProviderEndpointKey("client");
                SOAPAdapter sOAPAdapter = new SOAPAdapter(bPELProcess, endpointImpl);
                if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                    sOAPAdapter.setLog(this.log);
                }
                senderBehaviourImpl.setMessageAdapter(sOAPAdapter);
                node = scope.createNode(reply.getName(), senderBehaviourImpl);
                scope.getEndpoints().put("client", endpointImpl);
                this.initiateCorrelations(scope, reply.getCorrelations(), reply.getOutputVariable(), bPELProcess);
            }
            this.log.finest("end generate reply");
        }
        catch (BPELException bPELException) {
            throw new CoreException(bPELException);
        }
        return node;
    }

    private Node generateReceive(Scope scope, Receive receive, BPELProcess bPELProcess) throws CoreException {
        Node node = null;
        this.log.finest("start generate receive");
        try {
            if (receive != null) {
                this.initiateCorrelations(scope, receive.getCorrelations(), receive.getInputVariable(), bPELProcess);
                ReceiverBehaviourImpl receiverBehaviourImpl = new ReceiverBehaviourImpl();
                receiverBehaviourImpl.addVariableName(new QName(receive.getInputVariable()));
                this.log.finest("create receiver behaviour");
                BPELMessageMatcher bPELMessageMatcher = new BPELMessageMatcher(bPELProcess.getImports());
                if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                    bPELMessageMatcher.setLog(this.log);
                }
                receiverBehaviourImpl.setMessageMatcher(bPELMessageMatcher);
                if (!receive.getCreateInstance()) {
                    List<com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation> list = receive.getCorrelations();
                    if (list == null && receive.getCreateInstance()) {
                        list = new ArrayList<com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation>();
                    }
                    BPELCorrelationMatcher bPELCorrelationMatcher = new BPELCorrelationMatcher(bPELProcess, list, new QName(receive.getInputVariable()));
                    if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                        bPELCorrelationMatcher.setLog(this.log);
                    }
                    ArrayList<CorrelationMatcher> arrayList = new ArrayList<CorrelationMatcher>();
                    arrayList.add(bPELCorrelationMatcher);
                    receiverBehaviourImpl.setCorrelationsMatchers(arrayList);
                }
                node = scope.createNode(receive.getName(), receiverBehaviourImpl);
                this.log.finest("create receiver scope");
            }
        }
        catch (BPELException bPELException) {
            throw new CoreException(bPELException);
        }
        this.log.finest("end generate receive");
        return node;
    }

    private Node generateAssign(Scope scope, Assign assign, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate assign");
        Node node = null;
        if (assign != null) {
            AssignBehaviourImpl assignBehaviourImpl = new AssignBehaviourImpl();
            for (Copy copy : assign.getCopy()) {
                BPELAssignementExpressionImpl bPELAssignementExpressionImpl = new BPELAssignementExpressionImpl(copy, bPELProcess);
                if (!this.log.getName().equals(BPELCompilerImpl.class.getName())) {
                    bPELAssignementExpressionImpl.setLog(this.log);
                }
                assignBehaviourImpl.addAssignementExpression(bPELAssignementExpressionImpl);
            }
            node = scope.createNode(assign.getName(), assignBehaviourImpl);
        }
        this.log.finest("end generate assign");
        return node;
    }

    private Node generateEmpty(Scope scope, Empty empty, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate empty");
        Node node = scope.createNode(empty.getName(), new EmptyBehaviourImpl());
        return node;
    }

    private Node generateWait(Scope scope, Wait wait, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate wait");
        WaitBehaviourImpl waitBehaviourImpl = new WaitBehaviourImpl();
        if (wait.getUntil() != null) {
            waitBehaviourImpl.setDate((DateExpression)wait.getUntil().copypaste());
        }
        if (wait.getFor() != null) {
            waitBehaviourImpl.setDuration((LongExpression)wait.getFor().copypaste());
        }
        Node node = scope.createNode(wait.getName(), waitBehaviourImpl);
        return node;
    }

    private Node generateThrow(Scope scope, Throw throw_, BPELProcess bPELProcess) throws CoreException {
        Serializable serializable;
        this.log.finest("start generate throw");
        ThrowBehaviourImpl throwBehaviourImpl = new ThrowBehaviourImpl();
        try {
            if (throw_.getFaultName().getNamespaceURI().equals("http://docs.oasis-open.org/wsbpel/2.0/process/executable")) {
                serializable = BuiltInException.valueOfBPELBuiltInExceptionFrom(throw_.getFaultName().getLocalPart());
                if (serializable == null) {
                    throw new CoreException("Impossible to find built in exception constant from this value: " + throw_.getFaultName());
                }
                Class<?> clazz = serializable.getClass();
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                BPELException bPELException = (BPELException)constructor.newInstance(new Object[0]);
                throwBehaviourImpl.setException(bPELException);
            } else {
                serializable = bPELProcess.findVariable(new QName(throw_.getFaultVariable()));
                UserDefinedException userDefinedException = null;
                if (serializable.getElement() != null) {
                    this.log.finest("Creating new UserDefinedException based on a variable element");
                    userDefinedException = new UserDefinedException(throw_.getFaultName(), throw_.getFaultVariable(), UserDefinedException.FaultQnameType.ELEMENT_QNAME, serializable.getElement(), scope);
                } else {
                    this.log.finest("Creating new UserDefinedException based on a variable message");
                    userDefinedException = new UserDefinedException(throw_.getFaultName(), throw_.getFaultVariable(), UserDefinedException.FaultQnameType.MESSAGE_QNAME, serializable.getMessageType(), scope);
                }
                throwBehaviourImpl.setException(userDefinedException);
            }
        }
        catch (SecurityException securityException) {
            throw new CoreException(securityException);
        }
        catch (InstantiationException instantiationException) {
            throw new CoreException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CoreException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CoreException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CoreException(noSuchMethodException);
        }
        serializable = scope.createNode(throw_.getName(), throwBehaviourImpl);
        return serializable;
    }

    private Node generateExit(Scope scope, Exit exit, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate exit");
        Node node = scope.createNode(exit.getName(), new ExitBehaviourImpl());
        return node;
    }

    private Node generateReThrow(Scope scope, ReThrow reThrow, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate rethrow");
        ReThrowBehaviourImpl reThrowBehaviourImpl = new ReThrowBehaviourImpl();
        Node node = scope.createNode(reThrow.getName(), reThrowBehaviourImpl);
        this.log.finest("end generate rethrow");
        return node;
    }

    private Node generateActivity(Scope scope, Activity activity, BPELProcess bPELProcess) throws CoreException {
        this.log.finest("start generate activty: " + activity);
        Node node = null;
        if (activity != null) {
            if (activity instanceof Empty) {
                node = this.generateEmpty(scope, (Empty)activity, bPELProcess);
            } else if (activity instanceof Wait) {
                node = this.generateWait(scope, (Wait)activity, bPELProcess);
            } else if (activity instanceof Sequence) {
                node = this.generateSequence(scope, (Sequence)activity, bPELProcess);
            } else if (activity instanceof Flow) {
                node = this.generateFlow(scope, (Flow)activity, bPELProcess);
            } else if (activity instanceof If) {
                node = this.generateIf(scope, (If)activity, bPELProcess);
            } else if (activity instanceof While) {
                node = this.generateWhile(scope, (While)activity, bPELProcess);
            } else if (activity instanceof RepeatUntil) {
                node = this.generateRepeatUntil(scope, (RepeatUntil)activity, bPELProcess);
            } else if (activity instanceof ForEach) {
                node = this.generateForEach(scope, (ForEach)activity, bPELProcess);
            } else if (activity instanceof Invoke) {
                node = this.generateInvoke(scope, (Invoke)activity, bPELProcess);
            } else if (activity instanceof Receive) {
                node = this.generateReceive(scope, (Receive)activity, bPELProcess);
            } else if (activity instanceof Reply) {
                node = this.generateReply(scope, (Reply)activity, bPELProcess);
            } else if (activity instanceof Assign) {
                node = this.generateAssign(scope, (Assign)activity, bPELProcess);
            } else if (activity instanceof Pick) {
                node = this.generatePick(scope, (Pick)activity, bPELProcess);
            } else if (activity instanceof com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope) {
                node = this.generateScope(scope, (com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope)activity, bPELProcess);
            } else if (activity instanceof Throw) {
                node = this.generateThrow(scope, (Throw)activity, bPELProcess);
            } else if (activity instanceof ReThrow) {
                node = this.generateReThrow(scope, (ReThrow)activity, bPELProcess);
            } else if (activity instanceof Exit) {
                node = this.generateExit(scope, (Exit)activity, bPELProcess);
            } else if (activity instanceof ExtensionActivity) {
                node = this.generateExtendedActivity(scope, ((ExtensionActivity)activity).getExtendedActivity(), bPELProcess);
            } else {
                throw new CoreException("unknown activity: " + activity);
            }
        }
        this.log.finest("end generate activity");
        return node;
    }

    private Node generateExtendedActivity(Scope scope, ExtendedActivity extendedActivity, BPELProcess bPELProcess) throws CoreException {
        Node node = null;
        node = extendedActivity != null ? extendedActivity.generate(scope) : scope.createNode(null, new EmptyBehaviourImpl());
        return node;
    }

    @Override
    public void setLog(Logger logger) {
        this.log = logger;
    }
}

