/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.VariableValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import java.util.List;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Type;

public class VariableValidatorImpl
implements VariableValidator {
    private BPELVariable var = null;

    public VariableValidatorImpl(BPELVariable bPELVariable) {
        this.var = bPELVariable;
    }

    public void validate() {
        List<Type> list;
        Object object;
        if (this.var.getQName() == null || this.var.getQName().getLocalPart().trim().length() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.var, new BPELException("In variable definition => Variable cannot be null or empty")));
        }
        if (!(this.var.getMessageType() != null && this.var.getMessageType().getLocalPart().trim().length() != 0 || this.var.getElement() != null && this.var.getElement().getLocalPart().trim().length() != 0 || this.var.getTypeQName() != null && this.var.getTypeQName().getLocalPart().trim().length() != 0)) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.var, new BPELException("In variable definition => You must define the variable. Please, Set this type using messageType, element, or type attribute")));
        }
        BPELProcess bPELProcess = ScopeUtil.getProcess(this.var);
        if (this.var.getMessageType() != null && (object = bPELProcess.getImports().getMessage(this.var.getMessageType())) == null) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.var, new BPELException("In variable definition => Impossible to find message \"" + this.var.getMessageType() + "\" of variable " + this.var.getQName())));
        }
        if (this.var.getElement() != null && ((object = bPELProcess.getImports().findElementsInAllSchema(this.var.getElement())) == null || object.size() == 0)) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.var, new BPELException("In variable definition => Impossible to find element \"" + this.var.getElement() + "\" of variable " + this.var.getQName())));
        }
        if (this.var.getTypeQName() != null && (object = SchemaFactory.getDefaultSchema().getType(this.var.getTypeQName())) == null && (list = bPELProcess.getImports().findTypesInAllSchema(this.var.getTypeQName())).size() == 0) {
            BPELStaticAnalysisImpl.getInstance().addError(new BPELErrorImpl(this.var, new BPELException("In variable definition => Impossible to find type \"" + this.var.getElement() + "\" of variable " + this.var.getQName())));
        }
    }
}

