/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.generator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELFactory;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELWriter;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.generator.BPELGeneratorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.generator.BPELProject;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.ow2.easywsdl.extensions.wsdl4bpel.WSDL4BPELFactory;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELWriter;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.WSDLWriter;
import org.w3c.dom.Document;

public class BPELFromWSDLManager {
    private List<BPELProject> bpelProjects = new ArrayList<BPELProject>();
    private static WSDLReader reader = null;
    private static WSDLWriter writer = null;
    private static BPELWriter bpelWriter = null;
    private static WSDL4BPELWriter artifactWriter = null;

    public BPELFromWSDLManager(URL wsdlURL) throws WSDLException, MalformedURLException, IOException, URISyntaxException {
        Description wsdlBpel = reader.read(wsdlURL);
        for (InterfaceType currentInterface : wsdlBpel.getInterfaces()) {
            BPELProject project = new BPELGeneratorImpl().generateDefaultBPELProjectFromInterface(currentInterface.getQName(), wsdlBpel);
            this.bpelProjects.add(project);
        }
    }

    public boolean writeBPELProjects(File installDirectory) {
        boolean ok = false;
        for (BPELProject currentProject : this.bpelProjects) {
            File installSubDirectory = new File(installDirectory, currentProject.getBpelFileName());
            installSubDirectory.mkdirs();
            this.writeBPELProject(currentProject, installSubDirectory);
        }
        return ok;
    }

    public boolean writeBPELProject(BPELProject project, File installDirectory) {
        boolean ok = false;
        if (installDirectory.isDirectory() && installDirectory.canWrite()) {
            try {
                Document doc = bpelWriter.getDocument(project.getBpelProcess());
                this.write(new File(installDirectory, project.getBpelFileName()), XMLPrettyPrinter.prettyPrint(doc));
                Document docWsdl = writer.getDocument(project.getWsdlOfBpel());
                this.write(new File(installDirectory, project.getWsdlFileName()), XMLPrettyPrinter.prettyPrint(docWsdl));
                Document docArtifact = artifactWriter.getDocument(project.getWsdlArtifacts());
                this.write(new File(installDirectory, project.getArtifactFileName()), XMLPrettyPrinter.prettyPrint(docArtifact));
                ok = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ok;
    }

    public List<BPELProject> getBpelProjects() {
        return this.bpelProjects;
    }

    private boolean write(File f, String s) {
        boolean res = true;
        try {
            FileWriter fileWriter = new FileWriter(f);
            fileWriter.write(s);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            res = false;
        }
        return res;
    }

    static {
        try {
            BPELFactory bpelFactory = BPELFactoryImpl.getInstance();
            bpelWriter = bpelFactory.newBPELWriter();
            reader = WSDLFactory.newInstance().newWSDLReader();
            writer = WSDLFactory.newInstance().newWSDLWriter();
            artifactWriter = WSDL4BPELFactory.newInstance().newWSDLWriter();
        }
        catch (BPELException e) {
            e.printStackTrace();
        }
        catch (WSDLException e) {
            e.printStackTrace();
        }
    }
}

