/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.generator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.EasyNSFilter;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TEmpty;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPick;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReply;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSequence;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.EmptyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.PickImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ReplyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.SequenceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4pick.OnMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.wsdlImports.ImportImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.generator.BPELGenerator;
import com.ebmwebsourcing.easybpel.model.bpel.tools.generator.BPELProject;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.extensions.wsdl4bpel.WSDL4BPELFactory;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.extensions.wsdl4bpel.impl.PartnerLinkTypeImpl;
import org.ow2.easywsdl.extensions.wsdl4bpel.impl.RoleImpl;
import org.ow2.easywsdl.extensions.wsdl4bpel.org.oasis_open.docs.wsbpel._2_0.plnktype.TPartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.org.oasis_open.docs.wsbpel._2_0.plnktype.TRole;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Fault;
import org.ow2.easywsdl.wsdl.api.Import;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Output;
import org.ow2.easywsdl.wsdl.api.WSDLImportException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class BPELGeneratorImpl
implements BPELGenerator {
    private final String wsdlImportType = "http://schemas.xmlsoap.org/wsdl/";
    private Map<String, Operation> varInputMap = new TreeMap<String, Operation>();
    private Map<String, String> varInOut = new TreeMap<String, String>();
    private static int projectId = 0;
    private String defaultBpelName = "";
    private String defaultWsdlOfBpelName = "";
    private String defaultWsdlArtifactsName = "";
    private String defaultMainSequenceName = "MainSequence";
    private String defaultMainPickName = "MainPick";

    @Override
    public BPELProject generateBPELProjectFromInterface(QName interfaceQName, Description wsdlBpel, String bpelFileName, String wsdlFileName, String wsdlArtefactsName, String mainSequenceName, String mainPickName) {
        BPELProject bpelProject = null;
        try {
            XMLReader xmlReader = null;
            try {
                xmlReader = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            EasyNSFilter filter = new EasyNSFilter(xmlReader);
            HashMap<BPELReader.FeatureConstants, Object> features = new HashMap<BPELReader.FeatureConstants, Object>();
            features.put(BPELReader.FeatureConstants.VERBOSE, false);
            features.put(BPELReader.FeatureConstants.IMPORT_DOCUMENTS, true);
            BPELProcessImpl bpelProcess = new BPELProcessImpl(new URI(bpelFileName), new TProcess(), filter.getNamespaceMapper(), features);
            bpelProcess.setName(bpelFileName);
            bpelProcess.setTargetNamespace(wsdlBpel.getTargetNamespace());
            this.addImport(URI.create(this.wsdlImportType), URI.create(wsdlFileName), wsdlBpel, bpelProcess);
            Description artefactsDescClassic = WSDLFactory.newInstance().newDescription(AbsItfDescription.WSDLVersionConstants.WSDL11);
            org.ow2.easywsdl.extensions.wsdl4bpel.api.Description wsdlArtifacts = WSDL4BPELFactory.newInstance().addBPELElmt2Description(artefactsDescClassic);
            this.initWsdlArtefact(wsdlFileName, wsdlBpel, wsdlArtifacts, interfaceQName);
            this.addImport(URI.create(this.wsdlImportType), URI.create(wsdlArtefactsName), wsdlArtifacts, bpelProcess);
            this.createVariablesForInterface(wsdlBpel, interfaceQName, bpelProcess);
            PartnerLinkType plt = wsdlArtifacts.getPartnerLinkTypes().get(0);
            PartnerLink pl = bpelProcess.createPartnerLink();
            pl.setPartnerLinkType(plt.getQName());
            pl.setName("mainPartner");
            pl.setMyRole(pl.getName() + "Role");
            SequenceImpl seqMain = new SequenceImpl(new TSequence(), bpelProcess);
            seqMain.setName(mainSequenceName);
            bpelProcess.setActivity(seqMain);
            PickImpl mainPick = new PickImpl(new TPick(), seqMain);
            mainPick.setName(mainPickName);
            InterfaceType currentInterface = (InterfaceType)wsdlArtifacts.getInterface(interfaceQName);
            for (String var : this.varInputMap.keySet()) {
                OnMessageImpl om = new OnMessageImpl(new TOnMessage(), mainPick);
                om.setPartnerLink(pl.getName());
                om.setInputVariable(var);
                om.setInterface(currentInterface.getQName());
                om.setOperation(this.varInputMap.get(var).getQName().getLocalPart());
                if (this.varInputMap.get(var).getOutput() != null) {
                    ReplyImpl reply = new ReplyImpl(new TReply(), om);
                    reply.setInterface(currentInterface.getQName());
                    reply.setName("ReplyFor" + om.getOperation());
                    reply.setOperation(om.getOperation());
                    reply.setOutputVariable(this.varInOut.get(var));
                    reply.setPartnerLink(pl.getName());
                    om.setActivity(reply);
                } else {
                    om.setActivity(new EmptyImpl(new TEmpty(), om));
                }
                mainPick.addOnMessage(om);
            }
            seqMain.addActivity(mainPick);
            bpelProject = new BPELProject(bpelProcess, wsdlBpel, wsdlArtifacts);
            bpelProject.setBpelFileName(bpelFileName);
            bpelProject.setWsdlFileName(wsdlFileName);
            bpelProject.setArtifactFileName(wsdlArtefactsName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bpelProject;
    }

    @Override
    public BPELProject generateDefaultBPELProjectFromInterface(QName interfaceQName, Description wsdlBpel) {
        this.defaultBpelName = "process" + projectId + ".bpel";
        this.defaultWsdlOfBpelName = "process" + projectId + ".wsdl";
        this.defaultWsdlArtifactsName = "processArtifacts" + projectId + ".wsdl";
        this.defaultMainSequenceName = "MainSequence";
        this.defaultMainPickName = "MainPick";
        ++projectId;
        return this.generateBPELProjectFromInterface(interfaceQName, wsdlBpel, this.defaultBpelName, this.defaultWsdlOfBpelName, this.defaultWsdlArtifactsName, this.defaultMainSequenceName, this.defaultMainPickName);
    }

    private ImportImpl addImport(URI importType, URI location, Description wsdlDesc, BPELProcess bpelDef) {
        ImportImpl imp = new ImportImpl(new TImport(), bpelDef);
        imp.setImportType(importType);
        imp.setLocation(location);
        imp.setNamespace(URI.create(wsdlDesc.getTargetNamespace()));
        try {
            imp.setDescription(WSDL4BPELFactory.newInstance().addExtElmt2Description(wsdlDesc));
            bpelDef.addImport(imp);
        }
        catch (WSDL4BPELException e) {
            e.printStackTrace();
        }
        return imp;
    }

    private void createVariablesForInterface(Description desc, QName interfaceQName, BPELProcess bpelDef) {
        for (Operation op : ((InterfaceType)desc.getInterface(interfaceQName)).getOperations()) {
            String varName = ((Input)op.getInput()).getMessageName().getLocalPart() + "VarRequest";
            bpelDef.createBPELElementVariable(varName, ((Input)op.getInput()).getMessageName(), BPELElementVariable.VariableType.MESSAGE);
            this.varInputMap.put(varName, op);
            if (op.getOutput() != null) {
                String varOutName = ((Output)op.getOutput()).getMessageName().getLocalPart() + "VarResponse";
                bpelDef.createBPELElementVariable(varOutName, ((Output)op.getOutput()).getMessageName(), BPELElementVariable.VariableType.MESSAGE);
                this.varInOut.put(varName, varOutName);
            }
            if (op.getFaults() == null) continue;
            for (Fault f : op.getFaults()) {
                String varFaultName = f.getMessageName().getLocalPart() + "VarFault";
                bpelDef.createBPELElementVariable(varFaultName, f.getMessageName(), BPELElementVariable.VariableType.MESSAGE);
            }
        }
    }

    private void initWsdlArtefact(String wsdlFileName, Description wsdlOfBpel, org.ow2.easywsdl.extensions.wsdl4bpel.api.Description wsdlArtifacts, QName interfaceQName) throws SchemaException, WSDLImportException {
        Import import1 = (Import)wsdlArtifacts.createImport();
        import1.setLocationURI(URI.create(wsdlFileName));
        import1.setNamespaceURI(wsdlOfBpel.getTargetNamespace());
        import1.setDescription(wsdlOfBpel);
        wsdlArtifacts.addImport(import1);
        wsdlArtifacts.setTargetNamespace(wsdlOfBpel.getTargetNamespace() + "Artifacts");
        InterfaceType current = (InterfaceType)wsdlOfBpel.getInterface(interfaceQName);
        PartnerLinkTypeImpl plt = new PartnerLinkTypeImpl(new TPartnerLinkType(), wsdlArtifacts);
        QName pltQName = new QName(wsdlArtifacts.getTargetNamespace(), current.getQName().getLocalPart() + "PLT");
        plt.setQName(pltQName);
        RoleImpl role = new RoleImpl(new TRole(), plt);
        role.setName(current.getQName().getLocalPart() + "Role");
        role.setInterface(current);
        plt.addRole(role);
        wsdlArtifacts.addPartnerLinkType(plt);
    }
}

