/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.URLUtil;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.AnalysorResult;
import java.net.URL;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;

public class BPELAnalyser {
    private static BPELReader reader = null;
    private static BPELException readerEx = null;

    public static BPELReader getBPELReader() throws BPELException {
        if (readerEx != null) {
            throw readerEx;
        }
        return reader;
    }

    public BPELAnalyser() throws BPELException {
        BPELAnalyser.getBPELReader();
    }

    public AnalysorResult analyze(URL bpel) throws BPELException {
        AnalysorResult res = null;
        if (bpel == null) {
            throw new BPELException("bpel uri cannot be null!!!");
        }
        try {
            BPELStaticAnalysisImpl.getInstance().getErrors().clear();
            BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
            BPELStaticAnalysisImpl.getInstance().getInfos().clear();
            BPELProcess process = null;
            process = BPELAnalyser.getBPELReader().readBPEL(URLUtil.urlToUri(bpel));
            res = new AnalysorResult(process);
        }
        catch (WSDL4BPELException e) {
            throw new BPELException(e);
        }
        return res;
    }

    static {
        try {
            reader = BPELFactoryImpl.getInstance().newBPELReader();
        }
        catch (BPELException e) {
            readerEx = e;
        }
    }
}

