/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator.util;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.FaultHandlers;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.partnerLink.PartnerLinkImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathExpr;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import java.util.List;
import java.util.logging.Logger;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;

public class XPathBuilder {
    private static Logger log = Logger.getLogger(XPathBuilder.class.getName());

    public static XPathExpr createXPathExpressionFromBPELElement(BPELElement elmt) {
        XPathExpr res = new XPathExpr();
        res.setXPathExpression(XPathBuilder.buildRecursively(elmt, res.getNamespaceMapper()));
        return res;
    }

    private static String buildRecursively(BPELElement element, NamespaceMapperImpl ns) {
        String res = "";
        if (element != null) {
            BPELElement parent = (BPELElement)((Object)((BPELElementImpl)element).getParent());
            if (parent != null) {
                res = res + XPathBuilder.buildRecursively(parent, ns);
            }
            if (element.getTag() != null) {
                if (element instanceof BPELVariable) {
                    Integer indice;
                    res = res + "/" + Constants._Variables_QNAME.getPrefix() + ":" + Constants._Variables_QNAME.getLocalPart();
                    res = res + "/" + element.getTag().getPrefix() + ":" + element.getTag().getLocalPart();
                    if (((BPELVariable)element).getQName() != null && ((BPELVariable)element).getQName().getLocalPart() != null) {
                        res = res + "[@name=\"" + ((BPELVariable)element).getQName().getLocalPart() + "\"]";
                    }
                    if ((indice = XPathBuilder.findIndiceVariableInVariables((BPELVariable)element)) != null) {
                        res = res + "[" + indice + "]";
                    }
                } else if (element instanceof BPELExpression) {
                    res = res + "/" + element.getTag().getPrefix() + ":" + element.getTag().getLocalPart();
                } else if (element instanceof Import) {
                    res = res + "/" + element.getTag().getPrefix() + ":" + element.getTag().getLocalPart();
                    Integer indice = XPathBuilder.findIndiceImportInProcess((Import)element);
                    if (indice != null) {
                        res = res + "[" + indice + "]";
                    }
                } else if (element instanceof CorrelationSet) {
                    res = res + "/" + Constants._CorrelationSets_QNAME.getPrefix() + ":" + Constants._CorrelationSets_QNAME.getLocalPart();
                    res = res + "/" + element.getTag().getPrefix() + ":" + element.getTag().getLocalPart();
                    Integer indice = XPathBuilder.findIndiceCorrelationSetInProcess((CorrelationSet)element);
                    if (indice != null) {
                        res = res + "[" + indice + "]";
                    }
                } else if (element instanceof Correlation) {
                    res = res + "/" + element.getTag().getPrefix() + ":" + element.getTag().getLocalPart();
                    Integer indice = XPathBuilder.findIndiceCorrelationInExchange((Correlation)element);
                    if (indice != null) {
                        res = res + "[" + indice + "]";
                    }
                } else if (element instanceof PartnerLink) {
                    Integer indice;
                    res = res + "/" + Constants._PartnerLinks_QNAME.getPrefix() + ":" + Constants._PartnerLinks_QNAME.getLocalPart();
                    res = res + "/" + element.getTag().getPrefix() + ":" + element.getTag().getLocalPart();
                    if (((PartnerLink)element).getName() != null) {
                        res = res + "[@name=\"" + ((PartnerLink)element).getName() + "\"]";
                    }
                    if ((indice = XPathBuilder.findIndicePartnerLinkInPartnerLinks((PartnerLink)element)) != null) {
                        res = res + "[" + indice + "]";
                    }
                } else if (element instanceof Catch) {
                    res = res + "/" + element.getTag().getPrefix() + ":" + element.getTag().getLocalPart();
                    Integer indice = XPathBuilder.findIndiceCatchInParent((Catch)element);
                    if (indice != null) {
                        res = res + "[" + indice + "]";
                    }
                } else if (element instanceof OnMessage) {
                    res = res + "/" + element.getTag().getPrefix() + ":" + element.getTag().getLocalPart();
                    Integer indice = XPathBuilder.findIndiceOnMessageInPick((OnMessage)element);
                    if (indice != null) {
                        res = res + "[" + indice + "]";
                    }
                } else if (element instanceof Copy) {
                    res = res + "/" + element.getTag().getPrefix() + ":" + element.getTag().getLocalPart();
                    Integer indice = XPathBuilder.findIndiceCopyInAssign((Copy)element);
                    if (indice != null) {
                        res = res + "[" + indice + "]";
                    }
                } else {
                    res = res + "/" + element.getTag().getPrefix() + ":" + element.getTag().getLocalPart();
                }
                if (!ns.getNamespaces().containsKey(element.getTag().getPrefix())) {
                    ns.addNamespace(element.getTag().getPrefix(), element.getTag().getNamespaceURI());
                }
                if (element instanceof Activity) {
                    res = ((Activity)element).getName() != null ? res + "[@name=\"" + ((Activity)element).getName() + "\"]" : res + "[@name=\"\"]";
                }
            } else {
                log.severe("this element has no defined tag: " + element);
                res = res + "/" + "UNKNOWN_" + element.getClass().getSimpleName();
            }
        }
        return res;
    }

    private static Integer findIndiceCorrelationInExchange(Correlation element) {
        Integer res = null;
        int indice = 1;
        List<Correlation> correlation = null;
        BPELElement parent = (BPELElement)((Object)((BPELElementImpl)((Object)element)).getParent());
        if (parent instanceof Receive) {
            correlation = ((Receive)parent).getCorrelations();
        } else if (parent instanceof Invoke) {
            correlation = ((Invoke)parent).getCorrelations();
        } else if (parent instanceof Reply) {
            correlation = ((Invoke)parent).getCorrelations();
        }
        if (correlation != null) {
            for (Correlation item : correlation) {
                if (item == element) {
                    res = indice;
                    break;
                }
                ++indice;
            }
        }
        return res;
    }

    private static Integer findIndiceCatchInParent(Catch element) {
        Integer res = null;
        int indice = 1;
        List<Catch> _catchs = null;
        BPELElement parent = (BPELElement)((Object)((BPELElementImpl)((Object)element)).getParent());
        if (parent instanceof FaultHandlers) {
            _catchs = ((FaultHandlers)parent).getCatchs();
        } else if (parent instanceof Invoke) {
            _catchs = ((Invoke)parent).getCatchs();
        }
        if (_catchs != null) {
            for (Catch item : _catchs) {
                if (item == element) {
                    res = indice;
                    break;
                }
                ++indice;
            }
        }
        return res;
    }

    private static Integer findIndiceOnMessageInPick(OnMessage element) {
        Integer res = null;
        int indice = 1;
        List<OnMessage> onMessage = null;
        BPELElement parent = (BPELElement)((Object)((BPELElementImpl)((Object)element)).getParent());
        if (parent instanceof Pick) {
            onMessage = ((Pick)parent).getOnMessages();
        }
        if (onMessage != null) {
            for (OnMessage item : onMessage) {
                if (item == element) {
                    res = indice;
                    break;
                }
                ++indice;
            }
        }
        return res;
    }

    private static Integer findIndiceCopyInAssign(Copy element) {
        Integer res = null;
        int indice = 1;
        List<Copy> copy = null;
        BPELElement parent = (BPELElement)((Object)((BPELElementImpl)((Object)element)).getParent());
        if (parent instanceof Assign) {
            copy = ((Assign)parent).getCopy();
        }
        if (copy != null) {
            for (Copy item : copy) {
                if (item == element) {
                    res = indice;
                    break;
                }
                ++indice;
            }
        }
        return res;
    }

    private static Integer findIndiceVariableInVariables(BPELVariable var) {
        Integer res = null;
        int indice = 1;
        for (TVariable item : var.getVariables().getVariable()) {
            if (item == ((BPELElementImpl)((Object)var)).getModel()) {
                res = indice;
                break;
            }
            ++indice;
        }
        return res;
    }

    private static Integer findIndiceImportInProcess(Import element) {
        Integer res = null;
        int indice = 1;
        BPELProcess process = ScopeUtil.getProcess(element);
        for (TImport item : ((TProcess)((BPELElementImpl)((Object)process)).getModel()).getImport()) {
            if (item == ((BPELElementImpl)((Object)element)).getModel()) {
                res = indice;
                break;
            }
            ++indice;
        }
        return res;
    }

    private static Integer findIndiceCorrelationSetInProcess(CorrelationSet element) {
        Integer res = null;
        int indice = 1;
        BPELProcess process = ScopeUtil.getProcess(element);
        for (TCorrelationSet item : ((TProcess)((BPELElementImpl)((Object)process)).getModel()).getCorrelationSets().getCorrelationSet()) {
            if (item == ((BPELElementImpl)((Object)element)).getModel()) {
                res = indice;
                break;
            }
            ++indice;
        }
        return res;
    }

    private static Integer findIndicePartnerLinkInPartnerLinks(PartnerLink element) {
        Integer res = null;
        int indice = 1;
        PartnerLinkImpl pl = (PartnerLinkImpl)element;
        for (TPartnerLink item : pl.getPartnerLinks().getPartnerLink()) {
            if (item == ((BPELElementImpl)((Object)element)).getModel()) {
                res = indice;
                break;
            }
            ++indice;
        }
        return res;
    }
}

