/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TDurationExpr;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELDurationExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ASTStart;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionAnalyzer;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ExpressionDumpVisitor;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.ParseException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import java.net.URI;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.lang.NotImplementedException;
import org.jdom.Element;
import org.ow2.easywsdl.schema.api.XmlException;

public class BPELDurationExpressionImpl
extends BPELElementImpl<TDurationExpr>
implements BPELDurationExpression {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(BPELDurationExpressionImpl.class.getName());
    private final BPELProcess bpeldefinition;

    public BPELDurationExpressionImpl(TDurationExpr model, BPELElement parent) {
        super(Constants._For_QNAME, model, parent);
        this.bpeldefinition = ScopeUtil.getProcess(parent);
    }

    @Override
    public URI getExpressionLanguage() {
        URI res = null;
        if (this.model != null && ((TDurationExpr)this.model).getExpressionLanguage() != null) {
            res = URI.create(((TDurationExpr)this.model).getExpressionLanguage());
        }
        return res;
    }

    @Override
    public void setExpressionLanguage(URI language) {
        ((TDurationExpr)this.model).setExpressionLanguage(language.toString());
    }

    @Override
    public String getContent() {
        String content = null;
        if (((TDurationExpr)this.model).getContent() != null && ((TDurationExpr)this.model).getContent().size() > 0) {
            content = ((TDurationExpr)this.model).getContent().get(0).toString();
        }
        return content;
    }

    @Override
    public void setContent(String arg0) {
        throw new NotImplementedException();
    }

    @Override
    public List<org.w3c.dom.Element> getOtherElements() throws XmlException {
        throw new NotImplementedException();
    }

    @Override
    public Long evaluate(Scope scope) throws CoreException {
        Long time = null;
        String durationExpression = "";
        if (this.getContent() != null) {
            durationExpression = this.getContent();
        }
        try {
            Element result;
            this.log.finest("duration expression to evaluate: " + durationExpression);
            ExpressionAnalyzer analyzer = new ExpressionAnalyzer(durationExpression);
            ASTStart n = analyzer.Start();
            ExpressionDumpVisitor v = new ExpressionDumpVisitor(scope, this.bpeldefinition, null);
            if (!this.log.getName().equals(BPELDurationExpressionImpl.class.getName())) {
                v.setLog(this.log);
            }
            if ((result = n.jjtAccept(v, null)) instanceof BPELException) {
                throw (BPELException)((Object)result);
            }
            if (!(result instanceof Element)) {
                throw new BPELException("result unknown");
            }
            Element elmt = result;
            durationExpression = elmt.getText().replace("'", "");
            durationExpression = elmt.getText().replace("\"", "");
            time = DatatypeFactory.newInstance().newDuration(durationExpression).getTimeInMillis(Calendar.getInstance());
        }
        catch (DatatypeConfigurationException e) {
            throw new BPELException(e);
        }
        catch (BPELException e) {
            throw new CoreException("Impossible to evaluate expression: " + durationExpression, e);
        }
        catch (ParseException e) {
            throw new CoreException("Impossible to evaluate expression: " + durationExpression, e);
        }
        return time;
    }

    @Override
    public void setLog(Logger logger) {
        this.log = logger;
    }

    @Override
    public Expression<String, Long> copypaste() {
        BPELDurationExpressionImpl exp = new BPELDurationExpressionImpl((TDurationExpr)this.getModel(), (BPELElement)((Object)this.getParent()));
        return exp;
    }
}

