/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.api.model.registry.definition;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysis;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysisPrinter;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.tools.ProcessForker;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.objectweb.fractal.fraclet.types.Step;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Membrane(controller="primitive")
public abstract class AbstractProcessDefinitionRegistry<Def extends ProcessDefinition>
implements ProcessDefinitionRegistry<Def>,
BindingController,
LifeCycleController {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(AbstractProcessDefinitionRegistry.class.getName());
    protected Map<ProcessKey, Def> registry = new HashMap<ProcessKey, Def>();
    private StaticAnalysis staticAnalysis;
    private StaticAnalysisPrinter staticAnalysisPrinter;
    @Controller
    private org.objectweb.fractal.api.Component component;

    @Override
    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.listFc(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public AbstractProcessDefinitionRegistry() {
        try {
            this.createFc();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void listFc(List<String> list) {
    }

    @Override
    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    protected void createFc() throws Throwable {
        this.create();
    }

    @Override
    public String getFcState() {
        return null;
    }

    @Override
    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("component")) {
            this.component = (org.objectweb.fractal.api.Component)((org.objectweb.fractal.api.Component)object).getFcInterface("component");
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void unbindFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroyFc();
    }

    protected void destroyFc() throws Throwable {
        this.destroy();
    }

    @Override
    @Lifecycle(step=Step.CREATE)
    public void create() throws CoreException {
        log.fine("Fractal registry created: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    public void init(org.objectweb.fractal.api.Component component) throws CoreException {
        this.component = component;
        log.fine("Fractal registry initiated: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    @Lifecycle(step=Step.START)
    public void start() throws CoreException {
        log.fine("Fractal registry started: " + this.getName());
    }

    @Override
    @Lifecycle(step=Step.STOP)
    public void stop() throws CoreException {
        log.finest("sender " + this.getName() + " is stopping... ");
        log.finest("sender stopped: " + this.getName());
    }

    @Override
    @Lifecycle(step=Step.DESTROY)
    public void destroy() throws CoreException {
        log.fine("Fractal registry destroyed: " + this.getName());
    }

    @Override
    public String getName() throws CoreException {
        return FractalHelper.getFractalHelper().getName(this.component);
    }

    @Override
    public void setName(String string) throws CoreException {
        if (string != null) {
            FractalHelper.getFractalHelper().changeName(this.component, string);
        }
    }

    @Override
    public org.objectweb.fractal.api.Component getComponent() {
        return this.component;
    }

    public Model getModel() throws CoreException {
        Model model = null;
        try {
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getParent(this.getComponent());
            model = (Model)component.getFcInterface("service");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        return model;
    }

    @Override
    public StaticAnalysis getStaticAnalysis() {
        return this.staticAnalysis;
    }

    @Override
    public void setStaticAnalysis(StaticAnalysis staticAnalysis) {
        this.staticAnalysis = staticAnalysis;
    }

    @Override
    public StaticAnalysisPrinter getStaticAnalysisPrinter() {
        return this.staticAnalysisPrinter;
    }

    @Override
    public void setStaticAnalysisPrinter(StaticAnalysisPrinter staticAnalysisPrinter) {
        this.staticAnalysisPrinter = staticAnalysisPrinter;
    }

    @Override
    public synchronized ProcessDefinition storeProcessDefinition(URI uRI, ProcessContextDefinition processContextDefinition) throws CoreException {
        ProcessDefinition processDefinition = null;
        processDefinition = (ProcessDefinition)this.getModel().getCompiler().validate(uRI);
        log.finest("Number of process instances : " + this.getModel().getCore().getEngine().getProcessInstanceRegistry().getProcessInstances().size());
        if (this.getStaticAnalysis() != null && this.getStaticAnalysisPrinter() != null) {
            List<ProcessKey> list;
            if (this.getStaticAnalysis().getErrors().size() > 0) {
                String string = this.getStaticAnalysisPrinter().printAll(this.getStaticAnalysis().getErrors(), this.getStaticAnalysis().getWarnings(), this.getStaticAnalysis().getInfos());
                throw new CoreException("Compilation Error: " + string, (Throwable)this.getStaticAnalysis().getErrors().get(0).getError());
            }
            if (this.getStaticAnalysis().getWarnings().size() > 0) {
                list = this.getStaticAnalysisPrinter().printAll(this.getStaticAnalysis().getErrors(), this.getStaticAnalysis().getWarnings(), this.getStaticAnalysis().getInfos());
                log.finest("Compilation warning: " + (String)((Object)list));
            }
            list = null;
            list = this.createKeys(processDefinition);
            if (list == null || list.size() == 0) {
                throw new CoreException("The keys cannot be null");
            }
            String string = "\nList of key :\n";
            for (ProcessKey object : list) {
                string = String.valueOf(string) + object;
                this.registry.put(object, processDefinition);
            }
            log.finest(string);
            if (processContextDefinition.getPoolSize() > 0) {
                Process process = this.getModel().getCompiler().compile(processDefinition);
                process.run();
                log.info("First process started");
                int n = 1;
                while (n < processContextDefinition.getPoolSize()) {
                    ProcessForker processForker = new ProcessForker(n, processDefinition, this, list);
                    this.getModel().getCore().getEngine().getPoolOfProcessForkers().addProcessForkers(processForker);
                    processForker.start();
                    log.finest("process number" + n + " is going to be stored ...");
                    ++n;
                }
            }
        } else {
            log.severe("StaticAnalysis and StaticAnalysisPrinter MUST be set for this definition model.");
        }
        return processDefinition;
    }

    @Override
    public void unStoreProcessDefinition(URI uRI, boolean bl) throws CoreException {
        ProcessDefinition processDefinition = null;
        processDefinition = (ProcessDefinition)this.getModel().getCompiler().validate(uRI);
        List<ProcessKey> list = null;
        list = this.createKeys(processDefinition);
        if (list != null) {
            for (ProcessKey processKey : list) {
                this.removeProcessDefinition(processKey, bl);
            }
        }
    }

    @Override
    public abstract List<ProcessKey> createKeys(ProcessDefinition var1) throws CoreException;

    @Override
    public abstract <D extends ProcessDefinition> boolean isCreateInstance(D var1, InternalMessage<?> var2);
}

