/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.ExecutableElement;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.FractalComponent;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.fractal.Binding;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionMessage;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.ThreadExecution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.objectweb.fractal.fraclet.types.Cardinality;
import org.objectweb.fractal.fraclet.types.Contingency;
import org.objectweb.fractal.fraclet.types.Step;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@org.objectweb.fractal.fraclet.annotations.Interface(name="service", signature=Execution.class)})
@Membrane(controller="primitive")
public class ExecutionImpl
implements Execution,
BindingController,
LifeCycleController {
    protected BlockingQueue<ExecutionMessage> executionMessages = new LinkedBlockingQueue<ExecutionMessage>();
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(ExecutionImpl.class.getName());
    private boolean stepByStep = false;
    private Execution.State currentState = Execution.State.INACTIVE;
    @Requires(contingency=Contingency.OPTIONAL, name="currentTarget")
    private ExecutableElement currentTarget;
    @Requires(contingency=Contingency.OPTIONAL, name="parentExec")
    private Execution parent = null;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="childs")
    private final Map<String, Execution> childExecutions = new TreeMap<String, Execution>();
    private long speedTime;
    @Controller
    private org.objectweb.fractal.api.Component component;

    @Override
    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.listFc(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public ExecutionImpl() {
        try {
            this.createFc();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void listFc(List<String> list) {
        list.addAll((Collection<String>)this.childExecutions.keySet());
        if (this.parent != null) {
            list.add("parentExec");
        }
        if (this.currentTarget != null) {
            list.add("currentTarget");
        }
    }

    @Override
    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.startsWith("childs")) {
            return this.childExecutions.get(string);
        }
        if (string.equals("parentExec")) {
            return this.parent;
        }
        if (string.equals("currentTarget")) {
            return this.currentTarget;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    protected void createFc() throws Throwable {
        this.create();
    }

    @Override
    public String getFcState() {
        return null;
    }

    @Override
    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("component")) {
            this.component = (org.objectweb.fractal.api.Component)((org.objectweb.fractal.api.Component)object).getFcInterface("component");
        }
        if (string.startsWith("childs")) {
            this.childExecutions.put(string, (Execution)object);
            return;
        }
        if (string.equals("parentExec")) {
            this.parent = (Execution)object;
            return;
        }
        if (string.equals("currentTarget")) {
            this.currentTarget = (ExecutableElement)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.startsWith("childs")) {
            this.childExecutions.remove(string);
            return;
        }
        if (string.equals("parentExec")) {
            this.parent = null;
            return;
        }
        if (string.equals("currentTarget")) {
            this.currentTarget = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroyFc();
    }

    protected void destroyFc() throws Throwable {
        this.destroy();
    }

    @Override
    public ExecutableElement getCurrentTarget() {
        return this.currentTarget;
    }

    @Override
    public org.objectweb.fractal.api.Component getComponent() {
        return this.component;
    }

    @Override
    @Lifecycle(step=Step.CREATE)
    public void create() throws CoreException {
        this.log.fine("Fractal execution created: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    public void init(org.objectweb.fractal.api.Component component) throws CoreException {
        this.component = component;
        this.log.fine("Fractal execution initiated: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Override
    @Lifecycle(step=Step.START)
    public void start() throws CoreException {
        this.log.fine("start execution component: " + this.getName());
    }

    @Override
    @Lifecycle(step=Step.STOP)
    public void stop() throws CoreException {
        this.log.finest("stop execution component: " + this.getName());
    }

    @Override
    @Lifecycle(step=Step.DESTROY)
    public void destroy() throws CoreException {
        this.log.fine("Fractal execution destroyed: " + this.getName());
        this.setState(Execution.State.CANCELLED);
    }

    @Override
    public Scope getParentScope() throws CoreException {
        Scope scope = null;
        org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getParent(this.component);
        try {
            scope = (Scope)component.getFcInterface("scope");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        return scope;
    }

    @Override
    public synchronized void run() throws CoreException {
        assert (this.currentTarget != null);
        this.init();
        if (this.currentTarget != null) {
            this.setNextExecutableElements(null, this.currentTarget);
            while (this.getState() != Execution.State.ENDED && this.getState() != Execution.State.CANCELLED && this.getState() != Execution.State.SUSPENDED) {
                this.step();
            }
        } else {
            throw new CoreException("Error initialization exception");
        }
    }

    @Override
    public void removeChildExecution(Execution execution) throws CoreException {
        if (execution != null) {
            try {
                org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.getParentScope().getComponent(), (Interface)execution.getComponent().getFcInterface("service"), "service");
                if (component != null) {
                    FractalHelper.getFractalHelper().deleteComponent(component);
                }
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                throw new CoreException(noSuchInterfaceException);
            }
        }
    }

    @Override
    public void end() throws CoreException {
        try {
            if (FractalHelper.getFractalHelper().isBinded(this.component, "currentTarget")) {
                ArrayList<Binding> arrayList = new ArrayList<Binding>();
                arrayList.add(new Binding("currentTarget", (Interface)((Node)this.currentTarget).getComponent().getFcInterface("service")));
                FractalHelper.getFractalHelper().deleteBindings(this.component, arrayList);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
    }

    public Execution getChildExecution(String string) {
        return this.childExecutions.get(string);
    }

    @Override
    public List<Execution> getChildExecutions() {
        ArrayList<Execution> arrayList = new ArrayList<Execution>();
        arrayList.addAll(this.childExecutions.values());
        return arrayList;
    }

    @Override
    public String getName() throws CoreException {
        return FractalHelper.getFractalHelper().getName(this.component);
    }

    @Override
    public Execution getParentExecution() {
        return this.parent;
    }

    @Override
    public Execution.State getState() {
        return this.currentState;
    }

    @Override
    public void setStateRecursively(Execution.State state) {
        this.setState(state);
        try {
            if (!this.getParentScope().getName().equals(this.getParentScope().getProcess().getName())) {
                Execution execution = this.getParentScope().getExecution();
                execution.setStateRecursively(state);
            } else if (this.getParentExecution() != null) {
                this.getParentExecution().setStateRecursively(state);
            }
        }
        catch (CoreException coreException) {
            this.log.severe("error: " + coreException.getMessage());
        }
    }

    @Override
    public void setState(Execution.State state) {
        this.currentState = state;
    }

    @Override
    public void setName(String string) throws CoreException {
        if (string != null) {
            FractalHelper.getFractalHelper().changeName(this.component, string);
        }
    }

    public Execution createChildExecution(String string) throws CoreException {
        Execution execution = this.getParentScope().createExecution(String.valueOf(this.getName()) + "_child_" + this.childExecutions.size());
        org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.getParentScope().getComponent(), (Interface)((Object)execution), "service");
        FractalHelper.getFractalHelper().startComponent(component);
        execution.setStepByStep(this.stepByStep);
        execution.setSpeedTime(this.speedTime);
        this.log.finest("creating " + execution.getName());
        this.addExecution(execution);
        return execution;
    }

    @Override
    public void addExecution(Execution execution) throws CoreException {
        try {
            ArrayList<Binding> arrayList = new ArrayList<Binding>();
            arrayList.add(new Binding("childs_" + String.valueOf(this.childExecutions.size()), (Interface)execution.getComponent().getFcInterface("service")));
            FractalHelper.getFractalHelper().addBindings(this.getComponent(), arrayList);
            arrayList = new ArrayList();
            arrayList.add(new Binding("parentExec", (Interface)this.getComponent().getFcInterface("service")));
            FractalHelper.getFractalHelper().addBindings(execution.getComponent(), arrayList);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
    }

    @Override
    public void removeChildExecutions() throws CoreException {
        Execution execution = null;
        while (this.childExecutions.values() != null && this.childExecutions.values().size() > 0) {
            execution = this.childExecutions.values().iterator().next();
            this.log.finest("remove execution: " + execution.getName());
            this.removeChildExecution(execution);
        }
    }

    public void setParent(Execution execution) {
        this.parent = execution;
    }

    @Override
    public final boolean hasNextExecutableElement() {
        return !this.executionMessages.isEmpty();
    }

    @Override
    public final void setNextExecutableElements(FractalComponent fractalComponent, Collection<? extends ExecutableElement> collection) {
        assert (collection != null);
        this.executionMessages.add(new ExecutionMessage(fractalComponent, collection));
    }

    @Override
    public final void setNextExecutableElements(FractalComponent fractalComponent, ExecutableElement executableElement) {
        this.setNextExecutableElements(fractalComponent, (Collection<? extends ExecutableElement>)Collections.singletonList(executableElement));
    }

    private final void notifyParentExecution() throws CoreException {
        this.getParentExecution().setNextExecutableElements((FractalComponent)this, this.getParentExecution().getCurrentTarget());
    }

    @Override
    public final synchronized void step() throws CoreException {
        block16: {
            if (this.getState().equals((Object)Execution.State.ENDED)) {
                return;
            }
            try {
                ExecutionMessage executionMessage;
                ExecutionMessage executionMessage2 = this.executionMessages.take();
                Collection<? extends ExecutableElement> collection = executionMessage2.getNextExecutableElements();
                FractalComponent fractalComponent = executionMessage2.getSender();
                if (fractalComponent != null && fractalComponent instanceof Execution) {
                    this.removeChildExecution((Execution)fractalComponent);
                }
                if (collection.size() == 1) {
                    this.nextSequentially(collection.iterator().next());
                } else if (collection.size() > 1) {
                    try {
                        this.nextConcurrently(collection);
                    }
                    catch (NoSuchInterfaceException noSuchInterfaceException) {
                        throw new CoreException(noSuchInterfaceException);
                    }
                }
                if (!this.hasNextExecutableElement() && this.getChildExecutions().isEmpty() && this.getState() != Execution.State.SUSPENDED && this.getState() != Execution.State.CANCELLED) {
                    this.currentTarget.selectDefaultNextTarget();
                }
                if ((executionMessage = (ExecutionMessage)this.executionMessages.peek()) == null) {
                    return;
                }
                Collection<? extends ExecutableElement> collection2 = executionMessage.getNextExecutableElements();
                if (!collection2.isEmpty()) {
                    return;
                }
                this.executionMessages.clear();
                this.setState(Execution.State.ENDED);
                if (this.getParentExecution() != null) {
                    this.notifyParentExecution();
                    break block16;
                }
                Process process = null;
                try {
                    process = (Process)this.getParentScope().getComponent().getFcInterface("process");
                }
                catch (Exception exception) {}
                if (process != null && process.getState() == Process.State.PROCESS_ACTIVE) {
                    process.end(false);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new CoreException(interruptedException);
            }
        }
    }

    private final void nextSequentially(ExecutableElement executableElement) throws CoreException {
        this.execute(executableElement);
    }

    private final void nextConcurrently(Collection<? extends ExecutableElement> collection) throws CoreException, NoSuchInterfaceException {
        for (ExecutableElement executableElement : collection) {
            Execution execution = this.createChildExecution(String.valueOf(this.getName()) + "_child_" + this.childExecutions.size());
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(FractalHelper.getFractalHelper().getParent(this.getComponent()), (Interface)((Object)executableElement), "service");
            if (!FractalHelper.getFractalHelper().isAlreadyBind(execution.getComponent(), "currentTarget", (Interface)((Object)executableElement))) {
                this.getParentScope().linkedExecution2ExecutableElement((Execution)execution.getComponent().getFcInterface("service"), executableElement);
            }
            if (!FractalHelper.getFractalHelper().isAlreadyBind(component, "execution", (Interface)((Object)((Execution)execution.getComponent().getFcInterface("service"))))) {
                this.getParentScope().linkedExecutableElement2Execution((ExecutableElement)component.getFcInterface("service"), (Execution)execution.getComponent().getFcInterface("service"));
            }
            execution.setStepByStep(this.isStepByStep());
            ThreadExecution threadExecution = new ThreadExecution(execution);
            threadExecution.start();
        }
    }

    public synchronized void execute(ExecutableElement executableElement) throws CoreException {
        block8: {
            this.log.finest("Entering in execute method");
            try {
                if (executableElement == null) break block8;
                ExecutableElement executableElement2 = executableElement;
                org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(FractalHelper.getFractalHelper().getParent(this.getComponent()), (Interface)((Object)executableElement2), "service");
                FractalHelper.getFractalHelper().deleteLinkWithAnItfClientOfComponent(this.getComponent(), "currentTarget");
                if (component != null && !FractalHelper.getFractalHelper().isStarted(component)) {
                    FractalHelper.getFractalHelper().startComponent(component);
                }
                this.log.finest("run the next elmt for execution: " + this.getName() + " => " + executableElement2.getName());
                if (!FractalHelper.getFractalHelper().isAlreadyBind(this.getComponent(), "currentTarget", (Interface)((Object)executableElement2))) {
                    this.getParentScope().linkedExecution2ExecutableElement((Execution)this.getComponent().getFcInterface("service"), executableElement2);
                }
                if (!FractalHelper.getFractalHelper().isAlreadyBind(component, "execution", (Interface)((Object)((Execution)this.getComponent().getFcInterface("service"))))) {
                    this.getParentScope().linkedExecutableElement2Execution((ExecutableElement)component.getFcInterface("service"), (Execution)this.getComponent().getFcInterface("service"));
                }
                try {
                    if (component.getFcInterface("scope") != null) {
                        Node node = (Node)component.getFcInterface("service");
                        node.setExecution(this);
                    }
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {}
                executableElement.execute();
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                throw new CoreException(noSuchInterfaceException);
            }
        }
        this.log.finest("Exit of execute method");
    }

    @Override
    public long getSpeedTime() {
        return this.speedTime;
    }

    @Override
    public void setSpeedTime(long l) {
        this.speedTime = l;
    }

    @Override
    public void runSlowly(long l) throws CoreException {
        this.setSpeedTime(l);
        this.run();
    }

    public void init() throws CoreException {
        org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(FractalHelper.getFractalHelper().getParent(this.getComponent()), (Interface)((Object)this.currentTarget), "service");
        if (component != null && !FractalHelper.getFractalHelper().isStarted(component)) {
            FractalHelper.getFractalHelper().startComponent(component);
        }
        this.setState(Execution.State.ACTIVE);
    }

    @Override
    public void runStepByStep() throws CoreException {
        this.stepByStep = true;
        this.init();
        if (this.currentTarget == null) {
            throw new CoreException("Error initialization exception");
        }
        this.setNextExecutableElements(null, this.currentTarget);
    }

    @Override
    public synchronized void signal() throws CoreException {
        this.step();
    }

    @Override
    public boolean isStepByStep() {
        return this.stepByStep;
    }

    @Override
    public void setStepByStep(boolean bl) {
        this.stepByStep = bl;
    }

    @Override
    public void setLog(Logger logger) {
        this.log = logger;
    }

    public String toString() {
        String string = super.toString();
        try {
            if (this.getName() != null) {
                string = this.getName();
            }
        }
        catch (CoreException coreException) {}
        return string;
    }
}

