/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Assigner;
import com.ebmwebsourcing.easyviper.core.api.engine.monitoring.Monitor;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.ScopeImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.monitoring.MonitorImpl;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.extensions.Membrane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@org.objectweb.fractal.fraclet.annotations.Interface(name="process", signature=Process.class)})
@Membrane(controller="composite")
public class ProcessImpl
extends ScopeImpl
implements Process {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(ProcessImpl.class.getName());
    private List<ProcessKey> keys;
    private ExternalContext externalContext;
    private Monitor monitor = new MonitorImpl();
    private Process.State state = Process.State.PROCESS_INACTIVE;
    private Assigner assigner = null;

    @Override
    public void run() throws CoreException {
        this.log.finest("run process");
        if (this.state == Process.State.PROCESS_INACTIVE || this.state == Process.State.PROCESS_ENDED) {
            this.getMonitor().reset();
            this.getMonitor().setStartTime(Calendar.getInstance().getTime());
        }
        this.state = Process.State.PROCESS_ACTIVE;
        try {
            this.createParentExecution();
            this.log.finest("start parent execution");
            if (!FractalHelper.getFractalHelper().isStarted(this.parentExecution)) {
                FractalHelper.getFractalHelper().startComponent(this.parentExecution);
            }
            this.log.finest("parent execution started");
            this.log.finest("run the execution");
            Execution execution = (Execution)this.parentExecution.getFcInterface("service");
            execution.run();
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        this.log.finest("end of process");
    }

    @Override
    public Execution createParentExecution() throws CoreException {
        Execution execution = null;
        try {
            if (this.parentExecution == null) {
                this.log.finest("create parent execution");
                this.parentExecution = FractalHelper.getFractalHelper().createNewComponent(ExecutionImpl.class.getName(), null);
                execution = (Execution)this.parentExecution.getFcInterface("/content");
                if (!this.log.getName().equals(ProcessImpl.class.getName())) {
                    execution.setLog(this.log);
                }
                FractalHelper.getFractalHelper().addComponent(this.parentExecution, this.getComponent(), null);
                FractalHelper.getFractalHelper().changeName(this.parentExecution, "mainExec");
                if (this.initialNode == null) {
                    throw new CoreException("Initial node not setted");
                }
                this.linkInitialNodeAndExecution();
            }
            execution = (Execution)this.parentExecution.getFcInterface("service");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        return execution;
    }

    @Override
    public Map<String, Execution> getSuspendedExecutions() throws CoreException {
        HashMap<String, Execution> hashMap = new HashMap<String, Execution>();
        if (this.getParentExecution() != null && this.getParentExecution().getState().equals((Object)Execution.State.SUSPENDED)) {
            hashMap.putAll(this.getSuspendedExecutions(this.getParentExecution().getParentScope()));
        } else if (this.getParentExecution() == null) {
            Execution execution = this.createParentExecution();
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getComponentByInterface(this.getComponent(), (Interface)((Object)execution), "service");
            FractalHelper.getFractalHelper().startComponent(component);
            try {
                if (!hashMap.containsKey(this.getParentExecution().getName())) {
                    hashMap.put(this.getParentExecution().getName(), this.getParentExecution());
                }
            }
            catch (CoreException coreException) {}
        }
        return hashMap;
    }

    private Map<String, Execution> getSuspendedExecutions(Scope scope) {
        HashMap<String, Execution> hashMap = new HashMap<String, Execution>();
        try {
            this.log.finest("parentScope " + scope.getName());
            if (scope != null) {
                List<ReceiverBehaviour> list = scope.findBehaviours(ReceiverBehaviour.class);
                this.log.finest("Number of receiver behaviours: " + list.size());
                for (ReceiverBehaviour receiverBehaviour : list) {
                    this.log.finest("receiver behaviour: " + receiverBehaviour.getName());
                    if (receiverBehaviour.getNode().getExecution() == null || !receiverBehaviour.getNode().getExecution().getState().equals((Object)Execution.State.SUSPENDED) || hashMap.containsKey(receiverBehaviour.getNode().getExecution().getName())) continue;
                    this.log.finest("execution \"" + receiverBehaviour.getNode().getExecution().getName() + "\" of receiver behaviour \"" + receiverBehaviour.getName() + "\" is concerned execution.");
                    hashMap.put(receiverBehaviour.getNode().getExecution().getName(), receiverBehaviour.getNode().getExecution());
                }
            }
        }
        catch (CoreException coreException) {
            this.log.severe("Error in getSuspendedExecutions: " + coreException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            this.log.severe("Error in getSuspendedExecutions (null pointer): " + nullPointerException.getMessage());
        }
        return hashMap;
    }

    @Override
    public Engine getEngine() throws CoreException {
        Engine engine = null;
        try {
            org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getParent(this.getComponent());
            engine = (Engine)component.getFcInterface("service");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        return engine;
    }

    @Override
    public Process getProcess() throws CoreException {
        return this;
    }

    @Override
    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    @Override
    public void setExternalContext(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    @Override
    public Monitor getMonitor() {
        return this.monitor;
    }

    @Override
    public void end(boolean bl) throws CoreException {
        super.end(bl);
        this.setState(Process.State.PROCESS_ENDED);
        this.log.finest("PROCESS ENDED : " + this.getName());
        this.getMonitor().setEndTime(Calendar.getInstance().getTime());
        if (this.externalContext != null && this.externalContext.getTerminationHandler() != null) {
            this.externalContext.getTerminationHandler().end(this);
        }
    }

    @Override
    public Process.State getState() {
        return this.state;
    }

    @Override
    public void setState(Process.State state) {
        this.state = state;
    }

    @Override
    public String toString() {
        String string = super.toString();
        try {
            if (this.getName() != null) {
                string = this.getName();
            }
        }
        catch (CoreException coreException) {}
        return string;
    }

    @Override
    public List<ProcessKey> getProcessKeys() {
        return this.keys;
    }

    @Override
    public void setProcessKeys(List<ProcessKey> list) {
        this.keys = list;
    }

    @Override
    public Assigner getAssigner() {
        return this.assigner;
    }

    @Override
    public void setAssigner(Assigner assigner) {
        this.assigner = assigner;
    }
}

