/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.AbstractFunctionnalBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.AssignBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.AssignementExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Assigner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="service", signature=AssignBehaviour.class)})
public class AssignBehaviourImpl
extends AbstractFunctionnalBehaviourImpl
implements AssignBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(AssignBehaviourImpl.class.getName());
    @Requires(contingency=Contingency.OPTIONAL, name="node")
    protected Node node;
    private List<AssignementExpression> assignements = new ArrayList<AssignementExpression>();

    @Override
    protected void listFc(List<String> list) {
        if (this.node != null) {
            list.add("node");
        }
        super.listFc(list);
    }

    @Override
    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            return this.node;
        }
        return super.lookupFc(string);
    }

    @Override
    public Map<String, Object> getInitializationContext() throws CoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("assignements", this.assignements);
        return hashMap;
    }

    @Override
    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = (Node)object;
            return;
        }
        super.bindFc(string, object);
    }

    @Override
    public void setInitializationContext(Map<String, Object> map) throws CoreException {
        this.assignements = (List)map.get("assignements");
    }

    @Override
    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = null;
            return;
        }
        super.unbindFc(string);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String toString() {
        return "Assign";
    }

    @Override
    public void affect() throws CoreException {
        if (this.assignements != null) {
            for (AssignementExpression assignementExpression : this.assignements) {
                if (assignementExpression == null || assignementExpression.getLeft() == null) {
                    throw new CoreException("The left assignement is null");
                }
                Assigner assigner = this.getNode().getExecution().getParentScope().getProcess().getAssigner();
                if (assigner == null) {
                    throw new CoreException("Error: the assigner cannot be null");
                }
                this.log.finest("set " + assignementExpression.getRight() + " in " + assignementExpression.getLeft());
                assigner.affect(this.getNode().getExecution().getParentScope(), assignementExpression.getLeft(), assignementExpression.getRight());
            }
        }
    }

    @Override
    public void addAssignementExpression(AssignementExpression assignementExpression) {
        this.assignements.add(assignementExpression);
    }

    @Override
    public List<AssignementExpression> getAssignementExpressions() {
        return this.assignements;
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    @Override
    protected void executeOnEnded() throws CoreException {
    }

    @Override
    protected void executeOnInactive() throws CoreException {
        this.log.finest("start assign behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_STARTED;
        this.affect();
        this.log.finest("end of assign behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_ENDED;
    }

    @Override
    protected void executeOnStarted() throws CoreException {
    }
}

