/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.FractalComponent;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.AbstractFunctionnalBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.IfBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="service", signature=IfBehaviour.class)})
public class IfBehaviourImpl
extends AbstractFunctionnalBehaviourImpl
implements IfBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(IfBehaviourImpl.class.getName());
    @Requires(contingency=Contingency.OPTIONAL, name="node")
    protected Node node;
    private List<ConditionalExpression> conditions;

    @Override
    protected void listFc(List<String> list) {
        if (this.node != null) {
            list.add("node");
        }
        super.listFc(list);
    }

    @Override
    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            return this.node;
        }
        return super.lookupFc(string);
    }

    @Override
    public Map<String, Object> getInitializationContext() throws CoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("conditions", this.conditions);
        return hashMap;
    }

    @Override
    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = (Node)object;
            return;
        }
        super.bindFc(string, object);
    }

    @Override
    public void setInitializationContext(Map<String, Object> map) throws CoreException {
        this.conditions = (List)map.get("conditions");
    }

    @Override
    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = null;
            return;
        }
        super.unbindFc(string);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String toString() {
        return "If behaviour";
    }

    @Override
    public List<ConditionalExpression> getConditions() {
        return this.conditions;
    }

    @Override
    public void setConditions(List<ConditionalExpression> list) {
        this.conditions = list;
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    @Override
    protected void executeOnEnded() throws CoreException {
    }

    @Override
    protected void executeOnInactive() throws CoreException {
        this.log.finest("start if behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_STARTED;
        if (this.conditions != null && this.conditions.size() > 0) {
            Iterator<ConditionalExpression> iterator = this.conditions.iterator();
            Iterator<Node> iterator2 = this.node.getChildNodes().iterator();
            ConditionalExpression conditionalExpression = null;
            Node node = null;
            boolean bl = false;
            while (iterator.hasNext() && !bl) {
                conditionalExpression = iterator.next();
                node = iterator2.next();
                Boolean bl2 = (Boolean)conditionalExpression.evaluate(this.getNode().getExecution().getParentScope());
                if (bl2 == null || !bl2.booleanValue()) continue;
                this.getNode().getExecution().setNextExecutableElements((FractalComponent)this, node);
                bl = true;
            }
            if (!bl && iterator2.hasNext()) {
                node = iterator2.next();
                this.getNode().getExecution().setNextExecutableElements((FractalComponent)this, node);
                bl = true;
            }
            if (!bl) {
                this.log.finest("end if behaviour on node: " + this.node.getName());
                this.state = Behaviour.State.ACTIVITY_ENDED;
            }
        } else {
            throw new CoreException("Invalid if pattern");
        }
    }

    @Override
    protected void executeOnStarted() throws CoreException {
        this.log.finest("end if behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_ENDED;
    }
}

