/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.ExecutableElement;
import com.ebmwebsourcing.easyviper.core.api.engine.FractalComponent;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.AbstractFunctionnalBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.LoopBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="service", signature=LoopBehaviour.class)})
public class LoopBehaviourImpl
extends AbstractFunctionnalBehaviourImpl
implements LoopBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(LoopBehaviourImpl.class.getName());
    @Requires(contingency=Contingency.OPTIONAL, name="node")
    protected Node node;
    private ConditionalExpression condition;
    private boolean applyConditionAtBegin = true;

    @Override
    protected void listFc(List<String> list) {
        if (this.node != null) {
            list.add("node");
        }
        super.listFc(list);
    }

    @Override
    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            return this.node;
        }
        return super.lookupFc(string);
    }

    @Override
    public Map<String, Object> getInitializationContext() throws CoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("condition", this.condition);
        hashMap.put("applyConditionAtBegin", this.applyConditionAtBegin);
        return hashMap;
    }

    @Override
    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = (Node)object;
            return;
        }
        super.bindFc(string, object);
    }

    @Override
    public void setInitializationContext(Map<String, Object> map) throws CoreException {
        this.condition = (ConditionalExpression)map.get("condition");
        this.applyConditionAtBegin = (Boolean)map.get("applyConditionAtBegin");
    }

    @Override
    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = null;
            return;
        }
        super.unbindFc(string);
    }

    private void whileExecution() throws CoreException {
        Boolean bl = (Boolean)this.condition.evaluate(this.getNode().getExecution().getParentScope());
        if (bl != null && bl.booleanValue()) {
            List<Node> list = this.node.getChildNodes();
            if (list != null && list.size() > 0) {
                this.getNode().getExecution().setNextExecutableElements((FractalComponent)this, list.get(0));
            }
        } else {
            this.log.finest("end while behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_ENDED;
        }
    }

    private void repeatUntilExecution(boolean bl) throws CoreException {
        Object object;
        boolean bl2 = true;
        if (!(bl || (object = (Boolean)this.condition.evaluate(this.getNode().getExecution().getParentScope())) != null && ((Boolean)object).booleanValue())) {
            this.log.finest("end repeat until behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_ENDED;
            bl2 = false;
        }
        if (bl2 && (object = this.node.getChildNodes()) != null && object.size() > 0) {
            this.getNode().getExecution().setNextExecutableElements((FractalComponent)this, (ExecutableElement)object.get(0));
        }
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String toString() {
        return "Sequence";
    }

    @Override
    public ConditionalExpression getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(ConditionalExpression conditionalExpression) {
        this.condition = conditionalExpression;
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    @Override
    public boolean getApplyConditionAtBegin() {
        return this.applyConditionAtBegin;
    }

    @Override
    public void setApplyConditionAtBegin(boolean bl) {
        this.applyConditionAtBegin = bl;
    }

    @Override
    protected void executeOnEnded() throws CoreException {
    }

    @Override
    protected void executeOnInactive() throws CoreException {
        this.state = Behaviour.State.ACTIVITY_STARTED;
        if (this.applyConditionAtBegin) {
            this.log.finest("start while behaviour on node: " + this.node.getName());
            this.whileExecution();
        } else {
            this.log.finest("start repeat until behaviour on node: " + this.node.getName());
            this.repeatUntilExecution(true);
        }
    }

    @Override
    protected void executeOnStarted() throws CoreException {
        if (this.applyConditionAtBegin) {
            this.whileExecution();
        } else {
            this.repeatUntilExecution(false);
        }
    }
}

