/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Operation;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;
import com.ebmwebsourcing.easyviper.environment.test.util.XMLComparator;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationImpl
implements Operation {
    private static Logger log = Logger.getLogger(OperationImpl.class.getName());
    private String name;
    private String pattern;
    private List<Operation.MessageExchangeInstances> meis = new ArrayList<Operation.MessageExchangeInstances>();
    private int successfulInvocation = 0;
    private int invocationNumber = 0;
    private Service service;

    public OperationImpl() {
    }

    public OperationImpl(String string, String string2, Service service) {
        this.name = string;
        this.pattern = string2;
        this.service = service;
    }

    @Override
    public synchronized ExternalMessage execute(ExternalMessage externalMessage) throws CoreException {
        ExternalMessage externalMessage2 = null;
        Operation.MessageExchangeInstances object = null;
        ++this.invocationNumber;
        String string = null;
        String string2 = null;
        log.finest("actual msg BEFORE : \n" + externalMessage.toString());
        if (externalMessage.getContent() != null) {
            string = externalMessage.toString();
        }
        log.finest("actual msg:\n" + string);
        for (Operation.MessageExchangeInstances object2 : this.meis) {
            string2 = null;
            if (object2.getIn().getContent() != null) {
                string2 = object2.getIn().toString();
            }
            log.finest("expected msg:\n" + string2);
            if (string == null && string2 == null) {
                log.finest("Expected message is null ...");
                object = object2;
                break;
            }
            log.finest("Comparison of the expected message and the actual one.");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(string2.getBytes());
            try {
                log.fine("coucou1");
                if (XMLComparator.compare(byteArrayInputStream, byteArrayInputStream2) != 0) continue;
                object = object2;
                log.fine("coucou2");
                break;
            }
            catch (Exception exception) {
                log.fine("coucou3");
                throw new RuntimeException(exception);
            }
        }
        if (object == null) {
            try {
                Assert.fail("no input message corresponding to " + string + " in operation " + this.getName());
            }
            catch (AssertionFailedError assertionFailedError) {
                throw new RuntimeException((Throwable)((Object)assertionFailedError));
            }
        }
        if (object.getOut() != null) {
            log.finest("Message return: " + object.getOut().getContent());
            externalMessage2 = object.getOut();
        } else if (object.getFault() != null) {
            log.finest("Fault return: " + object.getFault().getContent());
            CoreException coreException = new CoreException();
            coreException.setFault(object.getFault());
            throw coreException;
        }
        ++this.successfulInvocation;
        return externalMessage2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setPattern(String string) {
        this.pattern = string;
    }

    @Override
    public List<Operation.MessageExchangeInstances> getMessageExchangeInstances() {
        return this.meis;
    }

    @Override
    public void setMessageExchangeInstances(List<Operation.MessageExchangeInstances> list) {
        this.meis = list;
    }

    @Override
    public void addMessageExchangeInstances(ExternalMessage externalMessage, ExternalMessage externalMessage2, ExternalMessage externalMessage3) {
        this.meis.add(new MessageExchangeInstancesImpl(externalMessage, externalMessage2, externalMessage3));
    }

    @Override
    public int getSuccessfulInvocation() {
        return this.successfulInvocation;
    }

    @Override
    public int getInvocationNumber() {
        return this.invocationNumber;
    }

    @Override
    public void clean() {
        this.successfulInvocation = 0;
        this.invocationNumber = 0;
    }

    @Override
    public Service getService() {
        return this.service;
    }

    @Override
    public void setService(Service service) {
        this.service = service;
    }

    public class MessageExchangeInstancesImpl
    implements Operation.MessageExchangeInstances {
        public ExternalMessage in;
        public ExternalMessage out;
        public ExternalMessage fault;

        public MessageExchangeInstancesImpl(ExternalMessage externalMessage, ExternalMessage externalMessage2, ExternalMessage externalMessage3) {
            this.in = externalMessage;
            this.out = externalMessage2;
            this.fault = externalMessage3;
        }

        public ExternalMessage getFault() {
            return this.fault;
        }

        public ExternalMessage getIn() {
            return this.in;
        }

        public ExternalMessage getOut() {
            return this.out;
        }

        public void setFault(ExternalMessage externalMessage) {
            this.fault = externalMessage;
        }

        public void setIn(ExternalMessage externalMessage) {
            this.in = externalMessage;
        }

        public void setOut(ExternalMessage externalMessage) {
            this.out = externalMessage;
        }
    }
}

