/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.w3c.dom.Element;

public class KeyResolver {
    static Log log = LogFactory.getLog(KeyResolver.class.getName());
    static boolean _alreadyInitialized = false;
    static List _resolverVector = null;
    protected KeyResolverSpi _resolverSpi = null;
    protected StorageResolver _storage = null;

    private KeyResolver(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._resolverSpi = (KeyResolverSpi)Class.forName(string).newInstance();
        this._resolverSpi.setGlobalResolver(true);
    }

    public static int length() {
        return _resolverVector.size();
    }

    public static void hit(Iterator iterator) {
        ResolverIterator resolverIterator = (ResolverIterator)iterator;
        int n = resolverIterator.i;
        if (n != 1 && resolverIterator.res == _resolverVector) {
            List list = (List)((ArrayList)_resolverVector).clone();
            Object e = list.remove(n - 1);
            list.add(0, e);
            _resolverVector = list;
        }
    }

    public static final X509Certificate getX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        List list = _resolverVector;
        for (int i = 0; i < list.size(); ++i) {
            Object[] objectArray;
            KeyResolver keyResolver = (KeyResolver)list.get(i);
            if (keyResolver == null) {
                objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", objectArray);
            }
            if (log.isDebugEnabled()) {
                log.debug("check resolvability by class " + keyResolver.getClass());
            }
            if ((objectArray = keyResolver.resolveX509Certificate(element, string, storageResolver)) == null) continue;
            return objectArray;
        }
        Object[] objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", objectArray);
    }

    public static final PublicKey getPublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        List list = _resolverVector;
        for (int i = 0; i < list.size(); ++i) {
            Object[] objectArray;
            KeyResolver keyResolver = (KeyResolver)list.get(i);
            if (keyResolver == null) {
                objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", objectArray);
            }
            if (log.isDebugEnabled()) {
                log.debug("check resolvability by class " + keyResolver.getClass());
            }
            if ((objectArray = keyResolver.resolvePublicKey(element, string, storageResolver)) == null) continue;
            if (i != 0 && list == _resolverVector) {
                list = (List)((ArrayList)_resolverVector).clone();
                Object e = list.remove(i);
                list.add(0, e);
                _resolverVector = list;
            }
            return objectArray;
        }
        Object[] objectArray = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", objectArray);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _resolverVector = new ArrayList(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        _resolverVector.add(new KeyResolver(string));
    }

    public static void registerAtStart(String string) {
        _resolverVector.add(0, string);
    }

    public PublicKey resolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return this._resolverSpi.engineLookupAndResolvePublicKey(element, string, storageResolver);
    }

    public X509Certificate resolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return this._resolverSpi.engineLookupResolveX509Certificate(element, string, storageResolver);
    }

    public SecretKey resolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return this._resolverSpi.engineLookupAndResolveSecretKey(element, string, storageResolver);
    }

    public void setProperty(String string, String string2) {
        this._resolverSpi.engineSetProperty(string, string2);
    }

    public String getProperty(String string) {
        return this._resolverSpi.engineGetProperty(string);
    }

    public boolean understandsProperty(String string) {
        return this._resolverSpi.understandsProperty(string);
    }

    public String resolverClassName() {
        return this._resolverSpi.getClass().getName();
    }

    public static Iterator iterator() {
        return new ResolverIterator(_resolverVector);
    }

    static class ResolverIterator
    implements Iterator {
        List res;
        Iterator it;
        int i;

        public ResolverIterator(List list) {
            this.res = list;
            this.it = this.res.iterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            ++this.i;
            KeyResolver keyResolver = (KeyResolver)this.it.next();
            if (keyResolver == null) {
                throw new RuntimeException("utils.resolver.noClass");
            }
            return keyResolver._resolverSpi;
        }

        public void remove() {
        }
    }
}

