/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.storage;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.storage.StorageResolverException;
import org.apache.xml.security.keys.storage.StorageResolverSpi;
import org.apache.xml.security.keys.storage.implementations.KeyStoreResolver;
import org.apache.xml.security.keys.storage.implementations.SingleCertificateResolver;

public class StorageResolver {
    static Log log = LogFactory.getLog(StorageResolver.class.getName());
    List _storageResolvers = null;
    Iterator _iterator = null;

    public StorageResolver() {
    }

    public StorageResolver(StorageResolverSpi storageResolverSpi) {
        this.add(storageResolverSpi);
    }

    public void add(StorageResolverSpi storageResolverSpi) {
        if (this._storageResolvers == null) {
            this._storageResolvers = new ArrayList();
        }
        this._storageResolvers.add(storageResolverSpi);
        this._iterator = null;
    }

    public StorageResolver(KeyStore keyStore) {
        this.add(keyStore);
    }

    public void add(KeyStore keyStore) {
        try {
            this.add(new KeyStoreResolver(keyStore));
        }
        catch (StorageResolverException storageResolverException) {
            log.error("Could not add KeyStore because of: ", storageResolverException);
        }
    }

    public StorageResolver(X509Certificate x509Certificate) {
        this.add(x509Certificate);
    }

    public void add(X509Certificate x509Certificate) {
        this.add(new SingleCertificateResolver(x509Certificate));
    }

    public Iterator getIterator() {
        if (this._iterator == null) {
            if (this._storageResolvers == null) {
                this._storageResolvers = new ArrayList();
            }
            this._iterator = new StorageResolverIterator(this._storageResolvers.iterator());
        }
        return this._iterator;
    }

    public boolean hasNext() {
        if (this._iterator == null) {
            if (this._storageResolvers == null) {
                this._storageResolvers = new ArrayList();
            }
            this._iterator = new StorageResolverIterator(this._storageResolvers.iterator());
        }
        return this._iterator.hasNext();
    }

    public X509Certificate next() {
        return (X509Certificate)this._iterator.next();
    }

    static class StorageResolverIterator
    implements Iterator {
        Iterator _resolvers = null;

        public StorageResolverIterator(Iterator iterator) {
            this._resolvers = iterator;
        }

        public boolean hasNext() {
            return this._resolvers.hasNext();
        }

        public Object next() {
            return this._resolvers.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

