/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.math.BigInteger;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.ElementChecker;
import org.apache.xml.security.utils.ElementCheckerImpl;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class ElementProxy {
    static Log log = LogFactory.getLog(ElementProxy.class.getName());
    protected Element _constructionElement = null;
    protected String _baseURI = null;
    protected Document _doc = null;
    static ElementChecker checker = new ElementCheckerImpl.InternedNsChecker();
    static HashMap _prefixMappings = new HashMap();
    static HashMap _prefixMappingsBindings = new HashMap();

    public abstract String getBaseNamespace();

    public abstract String getBaseLocalName();

    public ElementProxy() {
    }

    public ElementProxy(Document document) {
        if (document == null) {
            throw new RuntimeException("Document is null");
        }
        this._doc = document;
        this._constructionElement = this.createElementForFamilyLocal(this._doc, this.getBaseNamespace(), this.getBaseLocalName());
    }

    protected Element createElementForFamilyLocal(Document document, String string, String string2) {
        Element element = null;
        if (string == null) {
            element = document.createElementNS(null, string2);
        } else {
            String string3 = this.getBaseNamespace();
            String string4 = ElementProxy.getDefaultPrefix(string3);
            if (string4 == null || string4.length() == 0) {
                element = document.createElementNS(string, string2);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string);
            } else {
                String string5 = null;
                String string6 = ElementProxy.getDefaultPrefixBindings(string3);
                StringBuffer stringBuffer = new StringBuffer(string4);
                stringBuffer.append(':');
                stringBuffer.append(string2);
                string5 = stringBuffer.toString();
                element = document.createElementNS(string, string5);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", string6, string);
            }
        }
        return element;
    }

    public static Element createElementForFamily(Document document, String string, String string2) {
        Element element = null;
        String string3 = ElementProxy.getDefaultPrefix(string);
        if (string == null) {
            element = document.createElementNS(null, string2);
        } else if (string3 == null || string3.length() == 0) {
            element = document.createElementNS(string, string2);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string);
        } else {
            element = document.createElementNS(string, string3 + ":" + string2);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", ElementProxy.getDefaultPrefixBindings(string), string);
        }
        return element;
    }

    public void setElement(Element element, String string) throws XMLSecurityException {
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        if (log.isDebugEnabled()) {
            log.debug("setElement(" + element.getTagName() + ", \"" + string + "\"");
        }
        this._doc = element.getOwnerDocument();
        this._constructionElement = element;
        this._baseURI = string;
    }

    public ElementProxy(Element element, String string) throws XMLSecurityException {
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        if (log.isDebugEnabled()) {
            log.debug("setElement(\"" + element.getTagName() + "\", \"" + string + "\")");
        }
        this._doc = element.getOwnerDocument();
        this._constructionElement = element;
        this._baseURI = string;
        this.guaranteeThatElementInCorrectSpace();
    }

    public final Element getElement() {
        return this._constructionElement;
    }

    public final NodeList getElementPlusReturns() {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(this._doc.createTextNode("\n"));
        helperNodeList.appendChild(this.getElement());
        helperNodeList.appendChild(this._doc.createTextNode("\n"));
        return helperNodeList;
    }

    public Document getDocument() {
        return this._doc;
    }

    public String getBaseURI() {
        return this._baseURI;
    }

    void guaranteeThatElementInCorrectSpace() throws XMLSecurityException {
        checker.guaranteeThatElementInCorrectSpace(this, this._constructionElement);
    }

    public void addBigIntegerElement(BigInteger bigInteger, String string) {
        if (bigInteger != null) {
            Element element = XMLUtils.createElementInSignatureSpace(this._doc, string);
            Base64.fillElementWithBigInteger(element, bigInteger);
            this._constructionElement.appendChild(element);
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addBase64Element(byte[] byArray, String string) {
        if (byArray != null) {
            Element element = Base64.encodeToElement(this._doc, string, byArray);
            this._constructionElement.appendChild(element);
            if (!XMLUtils.ignoreLineBreaks()) {
                this._constructionElement.appendChild(this._doc.createTextNode("\n"));
            }
        }
    }

    public void addTextElement(String string, String string2) {
        Element element = XMLUtils.createElementInSignatureSpace(this._doc, string2);
        Text text = this._doc.createTextNode(string);
        element.appendChild(text);
        this._constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addBase64Text(byte[] byArray) {
        if (byArray != null) {
            Text text = XMLUtils.ignoreLineBreaks() ? this._doc.createTextNode(Base64.encode(byArray)) : this._doc.createTextNode("\n" + Base64.encode(byArray) + "\n");
            this._constructionElement.appendChild(text);
        }
    }

    public void addText(String string) {
        if (string != null) {
            Text text = this._doc.createTextNode(string);
            this._constructionElement.appendChild(text);
        }
    }

    public BigInteger getBigIntegerFromChildElement(String string, String string2) throws Base64DecodingException {
        return Base64.decodeBigIntegerFromText(XMLUtils.selectNodeText(this._constructionElement.getFirstChild(), string2, string, 0));
    }

    public byte[] getBytesFromChildElement(String string, String string2) throws XMLSecurityException {
        Element element = XMLUtils.selectNode(this._constructionElement.getFirstChild(), string2, string, 0);
        return Base64.decode(element);
    }

    public String getTextFromChildElement(String string, String string2) {
        Text text = (Text)XMLUtils.selectNode(this._constructionElement.getFirstChild(), string2, string, 0).getFirstChild();
        return text.getData();
    }

    public byte[] getBytesFromTextChild() throws XMLSecurityException {
        return Base64.decode(XMLUtils.getFullTextChildrenFromElement(this._constructionElement));
    }

    public String getTextFromTextChild() {
        return XMLUtils.getFullTextChildrenFromElement(this._constructionElement);
    }

    public int length(String string, String string2) {
        int n = 0;
        for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!string2.equals(node.getLocalName()) || string != node.getNamespaceURI()) continue;
            ++n;
        }
        return n;
    }

    public void setXPathNamespaceContext(String string, String string2) throws XMLSecurityException {
        if (string == null || string.length() == 0) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        if (string.equals("xmlns")) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        String string3 = string.startsWith("xmlns:") ? string : "xmlns:" + string;
        Attr attr = this._constructionElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", string3);
        if (attr != null) {
            if (!attr.getNodeValue().equals(string2)) {
                Object[] objectArray = new Object[]{string3, this._constructionElement.getAttributeNS(null, string3)};
                throw new XMLSecurityException("namespacePrefixAlreadyUsedByOtherURI", objectArray);
            }
            return;
        }
        this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", string3, string2);
    }

    public static void setDefaultPrefix(String string, String string2) throws XMLSecurityException {
        Object v;
        if (_prefixMappings.containsValue(string2) && !(v = _prefixMappings.get(string)).equals(string2)) {
            Object[] objectArray = new Object[]{string2, string, v};
            throw new XMLSecurityException("prefix.AlreadyAssigned", objectArray);
        }
        if ("http://www.w3.org/2000/09/xmldsig#".equals(string)) {
            XMLUtils.dsPrefix = string2;
        }
        _prefixMappings.put(string, string2.intern());
        if (string2.length() == 0) {
            _prefixMappingsBindings.put(string, "xmlns");
        } else {
            _prefixMappingsBindings.put(string, ("xmlns:" + string2).intern());
        }
    }

    public static String getDefaultPrefix(String string) {
        return (String)_prefixMappings.get(string);
    }

    public static String getDefaultPrefixBindings(String string) {
        return (String)_prefixMappingsBindings.get(string);
    }
}

