/*
 * Decompiled with CFR 0.152.
 */
package spoon;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import spoon.AbstractLauncher;
import spoon.processing.FileGenerator;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CtElement;
import spoon.support.ByteCodeOutputProcessor;
import spoon.support.JavaOutputProcessor;
import spoon.support.gui.SpoonModelTree;

public class Launcher
extends AbstractLauncher {
    public static void main(String[] args) throws Exception {
        try {
            new Launcher(args).run();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw exc;
        }
    }

    public Launcher(String[] args) throws JSAPException {
        super(args);
    }

    protected JSAP defineArgs() throws JSAPException {
        JSAP jsap = super.defineArgs();
        Switch sw1 = new Switch("nooutput");
        sw1.setLongFlag("no");
        sw1.setHelp("disable output printing");
        sw1.setDefault("false");
        jsap.registerParameter(sw1);
        sw1 = new Switch("compile");
        sw1.setShortFlag('c');
        sw1.setLongFlag("compile");
        sw1.setHelp("compile generated sources");
        jsap.registerParameter(sw1);
        FlaggedOption opt2 = new FlaggedOption("build");
        opt2.setShortFlag('b');
        opt2.setLongFlag("build");
        opt2.setDefault("spoonBuild");
        opt2.setHelp("specify where to place generated class files");
        opt2.setStringParser(FileStringParser.getParser());
        opt2.setRequired(false);
        jsap.registerParameter(opt2);
        sw1 = new Switch("gui");
        sw1.setShortFlag('g');
        sw1.setLongFlag("gui");
        sw1.setHelp("show spoon model after processing");
        jsap.registerParameter(sw1);
        return jsap;
    }

    protected Factory createFactory() {
        Factory f = super.createFactory();
        if (this.getArguments().getBoolean("compile")) {
            FileGenerator<? extends CtElement> printer = f.getEnvironment().getDefaultFileGenerator();
            ByteCodeOutputProcessor p = new ByteCodeOutputProcessor((JavaOutputProcessor)printer, this.getArguments().getFile("build"));
            f.getEnvironment().setDefaultFileGenerator(p);
        }
        return f;
    }

    protected void print() {
        if (!this.getArguments().getBoolean("nooutput")) {
            super.print();
        }
    }

    public void run() throws Exception {
        super.run();
        if (this.getArguments().getBoolean("gui")) {
            new SpoonModelTree(this.getFactory());
        }
    }
}

