/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.eval;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.eval.SymbolicInstance;
import spoon.reflect.eval.SymbolicStackFrame;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtVariableReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolicEvaluationStack {
    private Stack<SymbolicStackFrame> frameStack = new Stack();

    public boolean equals(Object obj) {
        SymbolicEvaluationStack c = (SymbolicEvaluationStack)obj;
        return this.frameStack.equals(c.frameStack);
    }

    public Stack<CtAbstractInvocation<?>> getCallingStack() {
        Stack s = new Stack();
        for (SymbolicStackFrame f : this.frameStack) {
            s.add(f.getInvocation());
        }
        return s;
    }

    public void enterFrame(CtAbstractInvocation<?> caller, SymbolicInstance<?> target, CtExecutableReference<?> executable, List<SymbolicInstance<?>> arguments, Map<CtVariableReference<?>, SymbolicInstance<?>> variables) {
        this.frameStack.push(new SymbolicStackFrame(caller, this.frameStack.isEmpty() ? null : this.frameStack.peek().getThis(), target, executable, arguments, variables));
    }

    public void exitFrame() {
        this.frameStack.pop();
    }

    public SymbolicInstance<?> getThis() {
        return this.frameStack.peek().getThis();
    }

    public SymbolicInstance<?> getVariableValue(CtVariableReference<?> vref) {
        if (this.frameStack.peek().getVariables().containsKey(vref)) {
            return this.frameStack.peek().getVariables().get(vref);
        }
        throw new RuntimeException("unknown variable '" + vref + "'");
    }

    public void setVariableValue(CtVariableReference<?> vref, SymbolicInstance<?> value) {
        if (!this.frameStack.peek().getVariables().containsKey(vref)) {
            throw new RuntimeException("unknown variable '" + vref + "'");
        }
        this.frameStack.peek().getVariables().put(vref, value);
    }

    public SymbolicEvaluationStack(SymbolicEvaluationStack stack) {
        for (SymbolicStackFrame f : stack.frameStack) {
            this.frameStack.add(new SymbolicStackFrame(f));
        }
    }

    public SymbolicEvaluationStack() {
    }

    public String toString() {
        return "" + this.frameStack;
    }

    public void dump() {
        System.out.println("Stack:");
        int i = 1;
        for (SymbolicStackFrame f : this.frameStack) {
            System.out.print(" " + i++ + "\t");
            System.out.println(f.toString());
        }
    }

    public SymbolicInstance<?> getResult() {
        return this.frameStack.peek().getResult();
    }

    public void setResult(SymbolicInstance<?> result) {
        this.frameStack.peek().setResult(result);
    }

    public Stack<SymbolicStackFrame> getFrameStack() {
        return this.frameStack;
    }
}

