/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.eval.observer;

import spoon.processing.Environment;
import spoon.reflect.eval.SymbolicEvaluationStep;
import spoon.reflect.eval.SymbolicEvaluator;
import spoon.reflect.eval.SymbolicEvaluatorObserver;
import spoon.support.reflect.eval.VisitorSymbolicEvaluator;

public class SymbolicEvaluationPrinter
implements SymbolicEvaluatorObserver {
    private int stepNumber = 0;
    private int pathNumber = 0;
    private Environment environment;

    public SymbolicEvaluationPrinter(Environment environment) {
        this.environment = environment;
    }

    public void onStartPath(SymbolicEvaluator evaluator) {
        this.stepNumber = 0;
        ++this.pathNumber;
        this.environment.reportProgressMessage("-- start dump path " + this.pathNumber);
    }

    public void onExitStep(VisitorSymbolicEvaluator evaluator, SymbolicEvaluationStep step) {
        this.environment.reportProgressMessage(++this.stepNumber + "\t" + (Object)((Object)step.getKind()) + " " + step.getFrame());
        step.getHeap().dump();
    }

    public void onEndPath(SymbolicEvaluator evaluator) {
        this.environment.reportProgressMessage("-- end dump path " + this.pathNumber);
    }

    public void onEnterStep(SymbolicEvaluator evaluator, SymbolicEvaluationStep step) {
        this.environment.reportProgressMessage(++this.stepNumber + "\t" + (Object)((Object)step.getKind()) + " " + step.getFrame());
        step.getHeap().dump();
    }
}

