/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.Collection;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCFlowBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtGenericElement;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtGenericElementReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CtInheritanceScanner
implements CtVisitor {
    @Override
    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
    }

    @Override
    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
    }

    public void scan(Collection<? extends CtElement> elements) {
        if (elements != null) {
            for (CtElement ctElement : elements) {
                this.scan(ctElement);
            }
        }
    }

    public void scan(CtElement element) {
        if (element != null) {
            element.accept(this);
        }
    }

    public void scan(CtReference reference) {
        if (reference != null) {
            reference.accept(this);
        }
    }

    public <T> void scanCtAbstractInvocation(CtAbstractInvocation<T> a) {
    }

    public void scanCtCFlowBreak(CtCFlowBreak flowBreak) {
        this.scanCtCodeElement(flowBreak);
    }

    public void scanCtCodeElement(CtCodeElement e) {
        this.scanCtElement(e);
    }

    public void scanCtElement(CtElement e) {
    }

    public <R> void scanCtExecutable(CtExecutable<R> e) {
        this.scanCtGenericElement(e);
        this.scanCtNamedElement(e);
    }

    public <T> void scanCtExpression(CtExpression<T> expression) {
        this.scanCtCodeElement(expression);
        this.scanCtTypedElement(expression);
    }

    public void scanCtGenericElement(CtGenericElement e) {
        this.scanCtElement(e);
    }

    public void scanCtGenericElementReference(CtGenericElementReference reference) {
    }

    public void scanCtLoop(CtLoop loop) {
        this.scanCtStatement(loop);
    }

    public void scanCtModifiable(CtModifiable m) {
        for (ModifierKind modifier : m.getModifiers()) {
            this.scanCtModifier(modifier);
        }
    }

    public void scanCtModifier(ModifierKind m) {
    }

    public void scanCtNamedElement(CtNamedElement e) {
        this.scanCtElement(e);
        this.scanCtModifiable(e);
    }

    public void scanCtReference(CtReference reference) {
    }

    public <T> void scanCtSimpleType(CtSimpleType<T> t) {
        this.scanCtNamedElement(t);
    }

    public void scanCtStatement(CtStatement s) {
        this.scanCtCodeElement(s);
    }

    public <T, E extends CtExpression<?>> void scanCtTargetedExpression(CtTargetedExpression<T, E> targetedExpression) {
        this.scanCtExpression(targetedExpression);
    }

    public <T> void scanCtType(CtType<T> type) {
        this.scanCtSimpleType(type);
        this.scanCtGenericElement(type);
    }

    public <T> void scanCtTypedElement(CtTypedElement<T> e) {
    }

    public <T> void scanCtVariable(CtVariable<T> v) {
        this.scanCtNamedElement(v);
        this.scanCtTypedElement(v);
    }

    public <T> void scanCtVariableReference(CtVariableReference<T> reference) {
        this.scanCtReference(reference);
    }

    public void scanReferences(Collection<? extends CtReference> references) {
        if (references != null) {
            for (CtReference ctReference : references) {
                this.scan(ctReference);
            }
        }
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        this.scanCtElement(annotation);
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.scanCtSimpleType(annotationType);
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable e) {
        this.scanCtElement(e);
        this.scanCtModifiable(e);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtArrayAccess(CtArrayAccess<T, E> arrayAccess) {
        this.scanCtTargetedExpression(arrayAccess);
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        this.visitCtTypeReference(reference);
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        this.scanCtStatement(asserted);
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        this.scanCtExpression(assignement);
        this.scanCtStatement(assignement);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        this.scanCtExpression(operator);
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        this.scanCtStatement(block);
    }

    @Override
    public void visitCtBreak(CtBreak breakStatement) {
        this.scanCtCFlowBreak(breakStatement);
    }

    public <E> void visitCtCase(CtCase<E> caseStatement) {
        this.scanCtStatement(caseStatement);
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        this.scanCtCodeElement(catchBlock);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.scanCtType(ctClass);
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        this.scanCtExpression(conditional);
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> c) {
        this.scanCtExecutable(c);
    }

    @Override
    public void visitCtContinue(CtContinue continueStatement) {
        this.scanCtCFlowBreak(continueStatement);
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        this.scanCtLoop(doLoop);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.visitCtClass(ctEnum);
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.scanCtReference(reference);
        this.scanCtGenericElementReference(reference);
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        this.scanCtNamedElement(f);
        this.scanCtVariable(f);
    }

    @Override
    public <T> void visitCtFieldAccess(CtFieldAccess<T> fieldAccess) {
        this.scanCtTargetedExpression(fieldAccess);
        this.visitCtVariableAccess(fieldAccess);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        this.scanCtVariableReference(reference);
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        this.scanCtLoop(forLoop);
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        this.scanCtLoop(foreach);
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        this.scanCtStatement(ifElement);
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.scanCtType(intrface);
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.scanCtTargetedExpression(invocation);
        this.scanCtStatement(invocation);
        this.scanCtAbstractInvocation(invocation);
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        this.scanCtExpression(literal);
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.scanCtVariable(localVariable);
        this.scanCtStatement(localVariable);
    }

    @Override
    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
        this.scanCtVariableReference(reference);
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        this.scanCtExecutable(m);
        this.scanCtTypedElement(m);
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        this.scanCtExpression(newArray);
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        this.scanCtAbstractInvocation(newClass);
        this.scanCtTypedElement(newClass);
        this.scanCtTargetedExpression(newClass);
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignement(CtOperatorAssignment<T, A> assignment) {
        this.visitCtAssignment(assignment);
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        this.scanCtNamedElement(ctPackage);
    }

    @Override
    public void visitCtPackageReference(CtPackageReference reference) {
        this.scanCtReference(reference);
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> parameter) {
        this.scanCtNamedElement(parameter);
        this.scanCtVariable(parameter);
    }

    @Override
    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
        this.scanCtVariableReference(reference);
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        this.scanCtCFlowBreak(returnStatement);
    }

    @Override
    public <R> void visitCtStatementList(CtStatementList<R> statements) {
        this.scanCtCodeElement(statements);
    }

    public <E> void visitCtSwitch(CtSwitch<E> switchStatement) {
        this.scanCtStatement(switchStatement);
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        this.scanCtStatement(synchro);
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        this.scanCtCFlowBreak(throwStatement);
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        this.scanCtStatement(tryBlock);
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        this.scanCtElement(typeParameter);
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        this.visitCtTypeReference(ref);
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        this.scanCtGenericElementReference(reference);
        this.scanCtReference(reference);
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.scanCtExpression(operator);
    }

    @Override
    public <T> void visitCtVariableAccess(CtVariableAccess<T> variableAccess) {
        this.scanCtExpression(variableAccess);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        this.scanCtLoop(whileLoop);
    }
}

