/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import spoon.processing.AbstractProcessor;
import spoon.processing.FileGenerator;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CtSimpleType;
import spoon.support.JavaOutputProcessor;
import spoon.support.util.ClassFileUtil;
import spoon.support.util.JDTCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteCodeOutputProcessor
extends AbstractProcessor<CtSimpleType<?>>
implements FileGenerator<CtSimpleType<?>> {
    public static final String CLASS_EXT = ".class";
    private File outputDir;
    private List<ICompilationUnit> units = new ArrayList<ICompilationUnit>();
    private List<File> printed = new ArrayList<File>();
    private List<String> printedTypes = new ArrayList<String>();
    private JavaOutputProcessor javaPrinter;

    public ByteCodeOutputProcessor(JavaOutputProcessor javaPrinter, File outputDirectory) {
        this.outputDir = outputDirectory;
        this.javaPrinter = javaPrinter;
    }

    @Override
    public List<File> getCreatedFiles() {
        return this.printed;
    }

    @Override
    public File getOutputDirectory() {
        return this.outputDir;
    }

    public long getJavaCompliance() {
        switch (this.getFactory().getEnvironment().getComplianceLevel()) {
            case 1: {
                return 2949123L;
            }
            case 2: {
                return 0x2E0000L;
            }
            case 3: {
                return 0x2F0000L;
            }
            case 4: {
                return 0x300000L;
            }
            case 5: {
                return 0x310000L;
            }
            case 6: {
                return 0x320000L;
            }
        }
        return 0x310000L;
    }

    @Override
    public void process(CtSimpleType<?> element) {
        if (!element.isTopLevel()) {
            return;
        }
        this.javaPrinter.getCreatedFiles().clear();
        this.javaPrinter.createJavaFile(element);
        for (File f : this.javaPrinter.getCreatedFiles()) {
            try {
                this.units.add(JDTCompiler.getUnit(element.getQualifiedName(), f));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void processingDone() {
        try {
            JDTCompiler compiler = new JDTCompiler();
            compiler.getCompilerOption().sourceLevel = this.getJavaCompliance();
            compiler.getCompilerOption().targetJDK = this.getJavaCompliance();
            compiler.compile(this.units.toArray(new ICompilationUnit[0]));
            this.getOutputDirectory().mkdirs();
            for (ClassFile f : compiler.getClassFiles()) {
                String fileName = new String(f.fileName()).replace('/', File.separatorChar) + CLASS_EXT;
                ClassFileUtil.adjustLineNumbers(f.getBytes(), f.headerOffset + f.methodCountOffset - 1, this.javaPrinter.getLineNumberMappings().get(new String(f.fileName()).replace('/', '.')));
                ClassFileUtil.writeToDisk(true, this.getOutputDirectory().getAbsolutePath(), fileName, f.getBytes());
                this.printed.add(new File(this.getOutputDirectory(), fileName));
                this.printedTypes.add(new String(f.fileName()).replace('/', '.'));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    @Override
    public void setFactory(Factory factory) {
        super.setFactory(factory);
        this.javaPrinter.setFactory(factory);
    }
}

