/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import spoon.processing.ProcessingManager;
import spoon.processing.Processor;
import spoon.processing.Severity;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.support.util.Timer;
import spoon.support.visitor.ProcessingVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeProcessingManager
implements ProcessingManager {
    Processor<?> current;
    Factory factory;
    List<Processor<?>> processors;
    ProcessingVisitor visitor;

    public RuntimeProcessingManager(Factory factory) {
        this.setFactory(factory);
    }

    @Override
    public void addProcessor(Class<? extends Processor<?>> type) {
        try {
            Processor<?> p = type.newInstance();
            p.setFactory(this.factory);
            p.init();
            this.addProcessor(p);
        }
        catch (Exception e) {
            this.factory.getEnvironment().report(null, Severity.ERROR, "Unable to instantiate processor \"" + type.getName() + "\" - Your processor should have a constructor with no arguments");
        }
    }

    @Override
    public boolean addProcessor(Processor<?> p) {
        p.setFactory(this.getFactory());
        return this.getProcessors().add(p);
    }

    @Override
    public void addProcessor(String qualifiedName) {
        try {
            this.addProcessor(Class.forName(qualifiedName));
        }
        catch (ClassNotFoundException e) {
            this.factory.getEnvironment().report(null, Severity.ERROR, "Unable to load processor \"" + qualifiedName + "\" - Check your classpath");
        }
    }

    @Override
    public Processor<?> getCurrentProcessor() {
        return this.current;
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    public List<Processor<?>> getProcessors() {
        if (this.processors == null) {
            this.processors = new LinkedList();
        }
        return this.processors;
    }

    private ProcessingVisitor getVisitor() {
        if (this.visitor == null) {
            this.visitor = new ProcessingVisitor(this.getFactory());
        }
        return this.visitor;
    }

    @Override
    public boolean isToBeApplied(Class<? extends Processor<?>> type) {
        for (Processor p : this.getProcessors()) {
            if (p.getClass() != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process() {
        Timer.start("process");
        this.process(this.getFactory().Package().getAllRoots());
        Timer.stop("process");
    }

    @Override
    public void process(Collection<? extends CtElement> elements) {
        Iterator i$ = this.getProcessors().iterator();
        while (i$.hasNext()) {
            Processor p;
            this.current = p = (Processor)i$.next();
            this.process(elements, p);
        }
    }

    public void process(Collection<? extends CtElement> elements, Processor<?> processor) {
        this.getFactory().getEnvironment().debugMessage("processing with '" + processor.getClass().getName() + "'...");
        this.current = processor;
        Timer.start(processor.getClass().getName());
        for (CtElement ctElement : elements) {
            this.process(ctElement, processor);
        }
        Timer.stop(processor.getClass().getName());
    }

    @Override
    public void process(CtElement element) {
        Iterator i$ = this.getProcessors().iterator();
        while (i$.hasNext()) {
            Processor p;
            this.current = p = (Processor)i$.next();
            this.process(element, p);
        }
    }

    public void process(CtElement element, Processor<?> processor) {
        this.getFactory().getEnvironment().debugMessage("processing '" + (element instanceof CtNamedElement ? ((CtNamedElement)element).getSimpleName() : element.toString()) + "' with '" + processor.getClass().getName() + "'...");
        processor.init();
        this.getVisitor().setProcessor(processor);
        this.getVisitor().scan(element);
        processor.processingDone();
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
        factory.getEnvironment().setManager(this);
    }
}

