/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.reflect.Factory;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.filter.AnnotationFilter;
import spoon.support.visitor.ElementReplacer;
import spoon.support.visitor.SignaturePrinter;
import spoon.support.visitor.TypeReferenceScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CtElementImpl
implements CtElement,
Serializable {
    transient Factory factory;
    Set<CtAnnotation<? extends Annotation>> annotations = new TreeSet<CtAnnotation<? extends Annotation>>();
    String docComment;
    CtElement parent;
    SourcePosition position;
    boolean implicit = false;

    @Override
    public String getSignature() {
        SignaturePrinter pr = new SignaturePrinter();
        pr.scan(this);
        return pr.getSignature();
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    @Override
    public int compareTo(CtElement o) {
        String current = this.getSignature();
        String other = o.getSignature();
        if (current.length() <= 0 || other.length() <= 0) {
            throw new ClassCastException("Unable to compare elements");
        }
        return current.compareTo(other);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        for (CtAnnotation<? extends Annotation> a : this.getAnnotations()) {
            if (!a.getAnnotationType().toString().equals(annotationType.getName())) continue;
            return (A)a.getActualAnnotation();
        }
        return null;
    }

    @Override
    public <A extends Annotation> CtAnnotation<A> getAnnotation(CtTypeReference<A> annotationType) {
        for (CtAnnotation<? extends Annotation> a : this.getAnnotations()) {
            if (!a.getAnnotationType().equals(annotationType)) continue;
            return a;
        }
        return null;
    }

    @Override
    public Set<CtAnnotation<? extends Annotation>> getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getDocComment() {
        return this.docComment;
    }

    @Override
    public CtElement getParent() {
        return this.parent;
    }

    @Override
    public <P extends CtElement> P getParent(Class<P> parentType) {
        if (this.getParent() == null) {
            return null;
        }
        if (parentType.isAssignableFrom(this.getParent().getClass())) {
            return (P)this.getParent();
        }
        return this.getParent().getParent(parentType);
    }

    @Override
    public boolean hasParent(CtElement candidate) {
        if (this.getParent() == null) {
            return false;
        }
        if (this.getParent() == candidate) {
            return true;
        }
        return this.getParent().hasParent(candidate);
    }

    @Override
    public SourcePosition getPosition() {
        return this.position;
    }

    public int hashCode() {
        SignaturePrinter pr = new SignaturePrinter();
        pr.scan(this);
        return pr.getSignature().hashCode();
    }

    @Override
    public void replace(CtElement element) {
        ElementReplacer<CtElement> translator = new ElementReplacer<CtElement>(this, element);
        this.getParent().accept(translator);
    }

    @Override
    public void replace(Filter<? extends CtElement> replacementPoints, CtElement element) {
        List<? extends CtElement> l = Query.getElements(this, replacementPoints);
        for (CtElement ctElement : l) {
            ctElement.replace(element);
        }
    }

    @Override
    public void setAnnotations(Set<CtAnnotation<? extends Annotation>> annotations) {
        this.annotations = annotations;
    }

    @Override
    public void setDocComment(String docComment) {
        this.docComment = docComment;
    }

    @Override
    public void setParent(CtElement parentElement) {
        this.parent = parentElement;
    }

    @Override
    public void setPosition(SourcePosition position) {
        this.position = position;
    }

    @Override
    public void setPositions(final SourcePosition position) {
        this.accept(new CtScanner(){

            public void enter(CtElement e) {
                e.setPosition(position);
            }
        });
    }

    public String toString() {
        DefaultJavaPrettyPrinter printer = new DefaultJavaPrettyPrinter(this.getFactory().getEnvironment());
        printer.scan(this);
        return printer.toString();
    }

    @Override
    public <E extends CtElement> List<E> getAnnotatedChildren(Class<? extends Annotation> annotationType) {
        return Query.getElements(this, new AnnotationFilter<CtElement>(CtElement.class, annotationType));
    }

    @Override
    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    @Override
    public Set<CtTypeReference<?>> getReferencedTypes() {
        TypeReferenceScanner s = new TypeReferenceScanner();
        s.scan(this);
        return s.getReferences();
    }
}

