/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.reflect.declaration.CtSimpleTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CtTypeImpl<T>
extends CtSimpleTypeImpl<T>
implements CtType<T> {
    List<CtTypeReference<?>> formalTypeParameters = new ArrayList();
    Set<CtTypeReference<?>> interfaces = new TreeSet();
    Set<CtMethod<?>> methods = new TreeSet();

    @Override
    public List<CtTypeReference<?>> getFormalTypeParameters() {
        return this.formalTypeParameters;
    }

    @Override
    public <R> CtMethod<R> getMethod(CtTypeReference<R> returnType, String name, CtTypeReference<?> ... parameterTypes) {
        for (CtMethod<?> mm : this.methods) {
            CtMethod<?> m = mm;
            if (!m.getSimpleName().equals(name) || !m.getType().equals(returnType)) continue;
            boolean cont = m.getParameters().size() == parameterTypes.length;
            for (int i = 0; cont && i < m.getParameters().size() && i < parameterTypes.length; ++i) {
                if (m.getParameters().get(i).getType().getQualifiedName().equals(parameterTypes[i].getQualifiedName())) continue;
                cont = false;
            }
            if (!cont) continue;
            return m;
        }
        return null;
    }

    @Override
    public CtMethod<?> getMethod(String name, CtTypeReference<?> ... parameterTypes) {
        for (CtMethod<?> m : this.methods) {
            if (!m.getSimpleName().equals(name)) continue;
            boolean cont = m.getParameters().size() == parameterTypes.length;
            for (int i = 0; cont && i < m.getParameters().size() && i < parameterTypes.length; ++i) {
                if (m.getParameters().get(i).getType().equals(parameterTypes[i])) continue;
                cont = false;
            }
            if (!cont) continue;
            return m;
        }
        return null;
    }

    @Override
    public Set<CtMethod<?>> getMethods() {
        return this.methods;
    }

    @Override
    public String getQualifiedName() {
        if (this.isTopLevel()) {
            return super.getQualifiedName();
        }
        if (this.getDeclaringType() != null) {
            return this.getDeclaringType().getQualifiedName() + "$" + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    @Override
    public Set<CtTypeReference<?>> getSuperInterfaces() {
        return this.interfaces;
    }

    @Override
    public void setFormalTypeParameters(List<CtTypeReference<?>> formalTypeParameters) {
        this.formalTypeParameters = formalTypeParameters;
    }

    @Override
    public void setMethods(Set<CtMethod<?>> methods) {
        this.methods = methods;
    }

    @Override
    public void setSuperInterfaces(Set<CtTypeReference<?>> interfaces) {
        this.interfaces = interfaces;
    }
}

