/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;

public class AnalysorResult {

	public List<URI> imports = new ArrayList<URI>();

	public List<URI> processDescriptions = new ArrayList<URI>();

	private BPELProcess process = null;

	public AnalysorResult(final BPELProcess process) throws WSDL4BPELException {
		this.process = process;

		// get all imports
		for (final Import impt : this.process.getImports().getBPELImports()) {
			if (!this.imports.contains(impt.getLocation())) {
				this.imports.add(impt.getLocation());
			}
		}

		// get all process description
		for (final AbsItfInterfaceType itf : this.process.getImports()
				.getProcessInterfaces()) {
			final AbsItfDescription desc = (AbsItfDescription) ((AbstractSchemaElementImpl) itf)
			.getParent();
			this.processDescriptions.add(desc.getDocumentBaseURI());
		}

	}

	public List<URI> getImports() {
		return this.imports;
	}

	public List<URI> getProcessDescriptions() {
		return this.processDescriptions;
	}

}
