/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easybpel.model.bpel.BPELFactory;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.Info;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.Warning;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.function.DoXslTransformFunctionImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.URLUtil;

public class BPELValidator {

	private static BPELReader reader = null;

	private static BPELException readerEx = null;

	private final DocumentBuilderFactory factory;

	static {
		try {
			reader = BPELFactory.newInstance().newBPELReader();
		} catch (final BPELException e) {
			readerEx = e;
		}
	}

	public static BPELReader getBPELReader() throws BPELException {
		if (readerEx != null) {
			throw readerEx;
		}
		return reader;
	}

	public BPELValidator() throws BPELException {
		BPELValidator.getBPELReader();
		this.factory = DocumentBuilderFactory.newInstance();
		this.factory.setNamespaceAware(true);
	}

	public ValidatorResult validate(final URL bpel) {
		final ValidatorResult res = new ValidatorResult();
		try {
			// clean static analysis
			StaticAnalysisImpl.getInstance().getErrors().clear();
			StaticAnalysisImpl.getInstance().getWarnings().clear();
			StaticAnalysisImpl.getInstance().getInfos().clear();

			final URI bpelURI = URLUtil.urlToUri(bpel);
			final InputStream is = bpel.openStream();

			// FIX JAXB BUG ON YES AND NO ENUMERATION
			// URL url = null;
			// InputStream is = null;
			// if(bpelURI.isAbsolute()) {
			// is = bpel.openStream();
			// url = bpel;
			// } else {
			// url = new URL(new File(".").toURL(), bpel.toString());
			// is = new FileInputStream(new File(url.toURI()));
			// }

			final Document bpelSrcDoc = this.factory.newDocumentBuilder().parse(is);
			final Document bpeltargetDoc = DoXslTransformFunctionImpl.process(Thread
					.currentThread().getContextClassLoader().getResource(
					"xslt/upperYesAndNoAttribute.xsl"), bpelSrcDoc,
					null);

			if (bpeltargetDoc.getDocumentURI() == null) {
				bpeltargetDoc.setDocumentURI(bpelURI.toString());
			}
			// END OF FIX BUGS

			BPELValidator.getBPELReader().readBPEL(bpeltargetDoc);

			// get errors from static analysis
			for (final com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.Error e : StaticAnalysisImpl
					.getInstance().getErrors()) {
				res.getErrors().add(new XPathError(e));
			}

			// get warnings from static analysis
			for (final Warning w : StaticAnalysisImpl.getInstance().getWarnings()) {
				res.getWarnings().add(new XPathWarning(w));
			}

			// get infos from static analysis
			for (final Info i : StaticAnalysisImpl.getInstance().getInfos()) {
				res.getInfos().add(new XPathInfo(i));
			}

		} catch (final BPELException e) {
			res.getErrors().add(new XPathError(null, e));
			e.printStackTrace();
		} catch (final IOException e) {
			res.getErrors().add(new XPathError(null, new BPELException(e)));
			e.printStackTrace();
		} catch (final SAXException e) {
			res.getErrors().add(new XPathError(null, new BPELException(e)));
			e.printStackTrace();
		} catch (final ParserConfigurationException e) {
			res.getErrors().add(new XPathError(null, new BPELException(e)));
			e.printStackTrace();
		}

		return res;
	}
}
