/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import com.ebmwebsourcing.easybpel.model.bpel.BPELFactory;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.Error;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.Info;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.Warning;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.function.DoXslTransformFunctionImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.URLUtil;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathError;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathInfo;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathWarning;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class BPELValidator {
    private static BPELReader reader = null;
    private static BPELException readerEx = null;
    private final DocumentBuilderFactory factory;

    public static BPELReader getBPELReader() throws BPELException {
        if (readerEx != null) {
            throw readerEx;
        }
        return reader;
    }

    public BPELValidator() throws BPELException {
        BPELValidator.getBPELReader();
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
    }

    public ValidatorResult validate(URL bpel) {
        ValidatorResult res = new ValidatorResult();
        try {
            StaticAnalysisImpl.getInstance().getErrors().clear();
            StaticAnalysisImpl.getInstance().getWarnings().clear();
            StaticAnalysisImpl.getInstance().getInfos().clear();
            URI bpelURI = URLUtil.urlToUri((URL)bpel);
            InputStream is = bpel.openStream();
            Document bpelSrcDoc = this.factory.newDocumentBuilder().parse(is);
            Document bpeltargetDoc = DoXslTransformFunctionImpl.process((URL)Thread.currentThread().getContextClassLoader().getResource("xslt/upperYesAndNoAttribute.xsl"), (Document)bpelSrcDoc, null);
            if (bpeltargetDoc.getDocumentURI() == null) {
                bpeltargetDoc.setDocumentURI(bpelURI.toString());
            }
            BPELValidator.getBPELReader().readBPEL(bpeltargetDoc);
            for (Error e : StaticAnalysisImpl.getInstance().getErrors()) {
                res.getErrors().add(new XPathError(e));
            }
            for (Warning w : StaticAnalysisImpl.getInstance().getWarnings()) {
                res.getWarnings().add(new XPathWarning(w));
            }
            for (Info i : StaticAnalysisImpl.getInstance().getInfos()) {
                res.getInfos().add(new XPathInfo(i));
            }
        }
        catch (BPELException e) {
            res.getErrors().add(new XPathError(null, e));
            e.printStackTrace();
        }
        catch (IOException e) {
            res.getErrors().add(new XPathError(null, new BPELException((Throwable)e)));
            e.printStackTrace();
        }
        catch (SAXException e) {
            res.getErrors().add(new XPathError(null, new BPELException((Throwable)e)));
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            res.getErrors().add(new XPathError(null, new BPELException((Throwable)e)));
            e.printStackTrace();
        }
        return res;
    }

    static {
        try {
            reader = BPELFactory.newInstance().newBPELReader();
        }
        catch (BPELException e) {
            readerEx = e;
        }
    }
}

