/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELValidator;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResultPrinter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class Main {
    private static BPELValidator validator = null;
    private static BPELException validatorException = null;

    public static BPELValidator getValidator() throws BPELException {
        if (validatorException != null) {
            throw validatorException;
        }
        return validator;
    }

    public static void main(String[] stringArray) {
        block12: {
            if (stringArray.length == 1) {
                if (stringArray[0].equals("-h") || stringArray[0].equals("-help")) {
                    Main.printHelp();
                } else {
                    try {
                        URL uRL = null;
                        File file = new File(stringArray[0]);
                        if (file.exists()) {
                            System.out.println("\nload file : " + file + "\n");
                            uRL = file.toURL();
                        } else {
                            System.out.println("\nload url : " + stringArray[0] + "\n");
                            uRL = new URL(stringArray[0]);
                        }
                        System.out.println("\nValidation of BPEL file at: " + uRL + "\n");
                        ValidatorResult validatorResult = Main.getValidator().validate(uRL);
                        if (validatorResult.getErrors().size() > 0) {
                            System.out.println("Validation errors ...");
                            System.out.println(ValidatorResultPrinter.getInstance().printAll(validatorResult));
                            break block12;
                        }
                        if (validatorResult.getWarnings().size() > 0) {
                            System.out.println("Validation Successfully Completed with Warnings!!!");
                            System.out.println(ValidatorResultPrinter.getInstance().printAll(validatorResult));
                            break block12;
                        }
                        System.out.println("Validation Successfully Completed ! Congratulations !");
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println("Impossible to find bpel file at this url: " + stringArray[0]);
                        malformedURLException.printStackTrace();
                    }
                    catch (BPELException bPELException) {
                        System.err.println("Internal BPELError: " + bPELException.getMessage());
                        bPELException.printStackTrace();
                    }
                }
            } else {
                String string = "";
                for (String string2 : stringArray) {
                    string = string + " " + string2;
                }
                System.err.println("Bad number or invalid arguments: " + string);
                Main.printHelp();
            }
        }
    }

    private static void printHelp() {
        System.out.println("Put:");
        System.out.println("\tfor help:               java -jar bpel-validator-tool.jar -h ");
        System.out.println("\tfor validate bpel file: java -jar bpel-validator-tool.jar \"bpel URI\"");
    }

    static {
        try {
            validator = new BPELValidator();
        }
        catch (BPELException bPELException) {
            validatorException = bPELException;
        }
    }
}

