/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.URLUtil;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.AnalysorResult;
import java.net.URL;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;

public class BPELAnalyser {
    private static BPELReader reader = null;
    private static BPELException readerEx = null;

    public static BPELReader getBPELReader() throws BPELException {
        if (readerEx != null) {
            throw readerEx;
        }
        return reader;
    }

    public BPELAnalyser() throws BPELException {
        BPELAnalyser.getBPELReader();
    }

    public AnalysorResult analyze(URL uRL) throws BPELException {
        AnalysorResult analysorResult = null;
        if (uRL == null) {
            throw new BPELException("bpel uri cannot be null!!!");
        }
        try {
            BPELStaticAnalysisImpl.getInstance().getErrors().clear();
            BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
            BPELStaticAnalysisImpl.getInstance().getInfos().clear();
            BPELProcess bPELProcess = null;
            bPELProcess = BPELAnalyser.getBPELReader().readBPEL(URLUtil.urlToUri((URL)uRL));
            analysorResult = new AnalysorResult(bPELProcess);
        }
        catch (WSDL4BPELException wSDL4BPELException) {
            throw new BPELException((Throwable)wSDL4BPELException);
        }
        return analysorResult;
    }

    static {
        try {
            reader = BPELFactoryImpl.getInstance().newBPELReader();
        }
        catch (BPELException bPELException) {
            readerEx = bPELException;
        }
    }
}

