/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELError;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELInfo;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELWarning;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.URLUtil;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathError;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathInfo;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathWarning;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.function.DoXslTransformFunctionImpl;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Error;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class BPELValidator {
    private static BPELReader reader = null;
    private static BPELException readerEx = null;
    private final DocumentBuilderFactory factory;

    public static BPELReader getBPELReader() throws BPELException {
        if (readerEx != null) {
            throw readerEx;
        }
        return reader;
    }

    public BPELValidator() throws BPELException {
        BPELValidator.getBPELReader();
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
    }

    public ValidatorResult validate(URL uRL) {
        ValidatorResult validatorResult = new ValidatorResult();
        try {
            BPELStaticAnalysisImpl.getInstance().getErrors().clear();
            BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
            BPELStaticAnalysisImpl.getInstance().getInfos().clear();
            URI uRI = URLUtil.urlToUri((URL)uRL);
            InputStream inputStream = uRL.openStream();
            Document document = this.factory.newDocumentBuilder().parse(inputStream);
            Document document2 = DoXslTransformFunctionImpl.process((URL)Thread.currentThread().getContextClassLoader().getResource("xslt/upperYesAndNoAttribute.xsl"), (Document)document, null);
            if (document2.getDocumentURI() == null) {
                document2.setDocumentURI(uRI.toString());
            }
            BPELValidator.getBPELReader().readBPEL(document2);
            for (Error error : BPELStaticAnalysisImpl.getInstance().getErrors()) {
                validatorResult.getErrors().add(new XPathError((BPELError)error));
            }
            for (Error error : BPELStaticAnalysisImpl.getInstance().getWarnings()) {
                validatorResult.getWarnings().add(new XPathWarning((BPELWarning)error));
            }
            for (Error error : BPELStaticAnalysisImpl.getInstance().getInfos()) {
                validatorResult.getInfos().add(new XPathInfo((BPELInfo)error));
            }
        }
        catch (BPELException bPELException) {
            validatorResult.getErrors().add(new XPathError(null, bPELException));
            bPELException.printStackTrace();
        }
        catch (IOException iOException) {
            validatorResult.getErrors().add(new XPathError(null, new BPELException((Throwable)iOException)));
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            validatorResult.getErrors().add(new XPathError(null, new BPELException((Throwable)sAXException)));
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            validatorResult.getErrors().add(new XPathError(null, new BPELException((Throwable)parserConfigurationException)));
            parserConfigurationException.printStackTrace();
        }
        catch (XPathExpressionException xPathExpressionException) {
            validatorResult.getErrors().add(new XPathError(null, new BPELException((Throwable)xPathExpressionException)));
            xPathExpressionException.printStackTrace();
        }
        return validatorResult;
    }

    static {
        try {
            reader = BPELFactoryImpl.getInstance().newBPELReader();
        }
        catch (BPELException bPELException) {
            readerEx = bPELException;
        }
    }
}

