/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathError;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathInfo;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathWarning;
import java.util.ArrayList;
import java.util.List;

public class ValidatorResultPrinter {
    private static ValidatorResultPrinter instance = new ValidatorResultPrinter();

    public static ValidatorResultPrinter getInstance() {
        return instance;
    }

    public List<String> printErrorsAsString(ValidatorResult validatorResult) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (XPathError xPathError : validatorResult.getErrors()) {
            arrayList.add(xPathError.getError().getMessage());
        }
        return arrayList;
    }

    public String printAllErrors(ValidatorResult validatorResult) {
        String string = "";
        for (String string2 : this.printErrorsAsString(validatorResult)) {
            string = string + string2 + "\n";
        }
        return string;
    }

    public String printAllWarnings(ValidatorResult validatorResult) {
        String string = "";
        for (XPathWarning xPathWarning : validatorResult.getWarnings()) {
            string = string + xPathWarning.getWarning() + "\n";
        }
        return string;
    }

    public String printAllInfos(ValidatorResult validatorResult) {
        String string = "";
        for (XPathInfo xPathInfo : validatorResult.getInfos()) {
            string = string + xPathInfo.getInfo() + "\n";
        }
        return string;
    }

    public String printAll(ValidatorResult validatorResult) {
        String string = "";
        if (validatorResult.getInfos() != null && validatorResult.getInfos().size() > 0) {
            string = string + validatorResult.getInfos().size() + " Infos:\n" + this.printAllInfos(validatorResult);
        }
        if (string.length() > 0) {
            string = string + "\n";
        }
        if (validatorResult.getWarnings() != null && validatorResult.getWarnings().size() > 0) {
            string = string + validatorResult.getWarnings().size() + " Warnings:\n" + this.printAllWarnings(validatorResult);
        }
        if (string.length() > 0) {
            string = string + "\n";
        }
        if (validatorResult.getErrors() != null && validatorResult.getErrors().size() > 0) {
            string = string + validatorResult.getErrors().size() + " Errors:\n" + this.printAllErrors(validatorResult);
        }
        return string;
    }

    public String printAllXPathExpression(ValidatorResult validatorResult) {
        String string = "";
        if (validatorResult.getInfos() != null && validatorResult.getInfos().size() > 0) {
            for (XPathInfo object : validatorResult.getInfos()) {
                string = string + object.getXpathExpression() + "\n";
            }
        }
        if (validatorResult.getWarnings() != null && validatorResult.getWarnings().size() > 0) {
            for (XPathWarning xPathWarning : validatorResult.getWarnings()) {
                string = string + xPathWarning.getXpathExpression() + "\n";
            }
        }
        if (validatorResult.getErrors() != null && validatorResult.getErrors().size() > 0) {
            for (XPathError xPathError : validatorResult.getErrors()) {
                string = string + xPathError.getXpathExpression() + "\n";
            }
        }
        return string;
    }
}

