/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator.util;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.FaultHandlers;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.util.ScopeUtil;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.impl.partnerLink.PartnerLinkImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathExpr;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELExpression;
import java.util.List;
import java.util.logging.Logger;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;

public class XPathBuilder {
    private static Logger log = Logger.getLogger(XPathBuilder.class.getName());

    public static XPathExpr createXPathExpressionFromBPELElement(BPELElement bPELElement) {
        XPathExpr xPathExpr = new XPathExpr();
        xPathExpr.setXPathExpression(XPathBuilder.buildRecursively(bPELElement, xPathExpr.getNamespaceMapper()));
        return xPathExpr;
    }

    private static String buildRecursively(BPELElement bPELElement, NamespaceMapperImpl namespaceMapperImpl) {
        String string = "";
        if (bPELElement != null) {
            BPELElement bPELElement2 = (BPELElement)((BPELElementImpl)bPELElement).getParent();
            if (bPELElement2 != null) {
                string = string + XPathBuilder.buildRecursively(bPELElement2, namespaceMapperImpl);
            }
            if (bPELElement.getTag() != null) {
                if (bPELElement instanceof BPELVariable) {
                    Integer n;
                    string = string + "/" + Constants._Variables_QNAME.getPrefix() + ":" + Constants._Variables_QNAME.getLocalPart();
                    string = string + "/" + bPELElement.getTag().getPrefix() + ":" + bPELElement.getTag().getLocalPart();
                    if (((BPELVariable)bPELElement).getQName() != null && ((BPELVariable)bPELElement).getQName().getLocalPart() != null) {
                        string = string + "[@name=\"" + ((BPELVariable)bPELElement).getQName().getLocalPart() + "\"]";
                    }
                    if ((n = XPathBuilder.findIndiceVariableInVariables((BPELVariable)bPELElement)) != null) {
                        string = string + "[" + n + "]";
                    }
                } else if (bPELElement instanceof BPELExpression) {
                    string = string + "/" + bPELElement.getTag().getPrefix() + ":" + bPELElement.getTag().getLocalPart();
                } else if (bPELElement instanceof Import) {
                    string = string + "/" + bPELElement.getTag().getPrefix() + ":" + bPELElement.getTag().getLocalPart();
                    Integer n = XPathBuilder.findIndiceImportInProcess((Import)bPELElement);
                    if (n != null) {
                        string = string + "[" + n + "]";
                    }
                } else if (bPELElement instanceof CorrelationSet) {
                    string = string + "/" + Constants._CorrelationSets_QNAME.getPrefix() + ":" + Constants._CorrelationSets_QNAME.getLocalPart();
                    string = string + "/" + bPELElement.getTag().getPrefix() + ":" + bPELElement.getTag().getLocalPart();
                    Integer n = XPathBuilder.findIndiceCorrelationSetInProcess((CorrelationSet)bPELElement);
                    if (n != null) {
                        string = string + "[" + n + "]";
                    }
                } else if (bPELElement instanceof Correlation) {
                    string = string + "/" + bPELElement.getTag().getPrefix() + ":" + bPELElement.getTag().getLocalPart();
                    Integer n = XPathBuilder.findIndiceCorrelationInExchange((Correlation)bPELElement);
                    if (n != null) {
                        string = string + "[" + n + "]";
                    }
                } else if (bPELElement instanceof PartnerLink) {
                    Integer n;
                    string = string + "/" + Constants._PartnerLinks_QNAME.getPrefix() + ":" + Constants._PartnerLinks_QNAME.getLocalPart();
                    string = string + "/" + bPELElement.getTag().getPrefix() + ":" + bPELElement.getTag().getLocalPart();
                    if (((PartnerLink)bPELElement).getName() != null) {
                        string = string + "[@name=\"" + ((PartnerLink)bPELElement).getName() + "\"]";
                    }
                    if ((n = XPathBuilder.findIndicePartnerLinkInPartnerLinks((PartnerLink)bPELElement)) != null) {
                        string = string + "[" + n + "]";
                    }
                } else if (bPELElement instanceof Catch) {
                    string = string + "/" + bPELElement.getTag().getPrefix() + ":" + bPELElement.getTag().getLocalPart();
                    Integer n = XPathBuilder.findIndiceCatchInParent((Catch)bPELElement);
                    if (n != null) {
                        string = string + "[" + n + "]";
                    }
                } else if (bPELElement instanceof OnMessage) {
                    string = string + "/" + bPELElement.getTag().getPrefix() + ":" + bPELElement.getTag().getLocalPart();
                    Integer n = XPathBuilder.findIndiceOnMessageInPick((OnMessage)bPELElement);
                    if (n != null) {
                        string = string + "[" + n + "]";
                    }
                } else if (bPELElement instanceof Copy) {
                    string = string + "/" + bPELElement.getTag().getPrefix() + ":" + bPELElement.getTag().getLocalPart();
                    Integer n = XPathBuilder.findIndiceCopyInAssign((Copy)bPELElement);
                    if (n != null) {
                        string = string + "[" + n + "]";
                    }
                } else {
                    string = string + "/" + bPELElement.getTag().getPrefix() + ":" + bPELElement.getTag().getLocalPart();
                }
                if (!namespaceMapperImpl.getNamespaces().containsKey(bPELElement.getTag().getPrefix())) {
                    namespaceMapperImpl.addNamespace(bPELElement.getTag().getPrefix(), bPELElement.getTag().getNamespaceURI());
                }
                if (bPELElement instanceof Activity) {
                    string = ((Activity)bPELElement).getName() != null ? string + "[@name=\"" + ((Activity)bPELElement).getName() + "\"]" : string + "[@name=\"\"]";
                }
            } else {
                log.severe("this element has no defined tag: " + bPELElement);
                string = string + "/" + "UNKNOWN_" + bPELElement.getClass().getSimpleName();
            }
        }
        return string;
    }

    private static Integer findIndiceCorrelationInExchange(Correlation correlation) {
        Integer n = null;
        int n2 = 1;
        List list = null;
        BPELElement bPELElement = (BPELElement)((BPELElementImpl)correlation).getParent();
        if (bPELElement instanceof Receive) {
            list = ((Receive)bPELElement).getCorrelations();
        } else if (bPELElement instanceof Invoke) {
            list = ((Invoke)bPELElement).getCorrelations();
        } else if (bPELElement instanceof Reply) {
            list = ((Invoke)bPELElement).getCorrelations();
        }
        if (list != null) {
            for (Correlation correlation2 : list) {
                if (correlation2 == correlation) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    private static Integer findIndiceCatchInParent(Catch catch_) {
        Integer n = null;
        int n2 = 1;
        List list = null;
        BPELElement bPELElement = (BPELElement)((BPELElementImpl)catch_).getParent();
        if (bPELElement instanceof FaultHandlers) {
            list = ((FaultHandlers)bPELElement).getCatchs();
        } else if (bPELElement instanceof Invoke) {
            list = ((Invoke)bPELElement).getCatchs();
        }
        if (list != null) {
            for (Catch catch_2 : list) {
                if (catch_2 == catch_) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    private static Integer findIndiceOnMessageInPick(OnMessage onMessage) {
        Integer n = null;
        int n2 = 1;
        List list = null;
        BPELElement bPELElement = (BPELElement)((BPELElementImpl)onMessage).getParent();
        if (bPELElement instanceof Pick) {
            list = ((Pick)bPELElement).getOnMessages();
        }
        if (list != null) {
            for (OnMessage onMessage2 : list) {
                if (onMessage2 == onMessage) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    private static Integer findIndiceCopyInAssign(Copy copy) {
        Integer n = null;
        int n2 = 1;
        List list = null;
        BPELElement bPELElement = (BPELElement)((BPELElementImpl)copy).getParent();
        if (bPELElement instanceof Assign) {
            list = ((Assign)bPELElement).getCopy();
        }
        if (list != null) {
            for (Copy copy2 : list) {
                if (copy2 == copy) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    private static Integer findIndiceVariableInVariables(BPELVariable bPELVariable) {
        Integer n = null;
        int n2 = 1;
        for (TVariable tVariable : bPELVariable.getVariables().getVariable()) {
            if (tVariable == ((BPELElementImpl)bPELVariable).getModel()) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    private static Integer findIndiceImportInProcess(Import import_) {
        Integer n = null;
        int n2 = 1;
        BPELProcess bPELProcess = ScopeUtil.getProcess((BPELElement)import_);
        for (TImport tImport : ((TProcess)((BPELElementImpl)bPELProcess).getModel()).getImport()) {
            if (tImport == ((BPELElementImpl)import_).getModel()) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    private static Integer findIndiceCorrelationSetInProcess(CorrelationSet correlationSet) {
        Integer n = null;
        int n2 = 1;
        BPELProcess bPELProcess = ScopeUtil.getProcess((BPELElement)correlationSet);
        for (TCorrelationSet tCorrelationSet : ((TProcess)((BPELElementImpl)bPELProcess).getModel()).getCorrelationSets().getCorrelationSet()) {
            if (tCorrelationSet == ((BPELElementImpl)correlationSet).getModel()) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    private static Integer findIndicePartnerLinkInPartnerLinks(PartnerLink partnerLink) {
        Integer n = null;
        int n2 = 1;
        PartnerLinkImpl partnerLinkImpl = (PartnerLinkImpl)partnerLink;
        for (TPartnerLink tPartnerLink : partnerLinkImpl.getPartnerLinks().getPartnerLink()) {
            if (tPartnerLink == ((BPELElementImpl)partnerLink).getModel()) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }
}

