/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELValidator;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResultPrinter;

public class Main {

	private static BPELValidator validator = null;
	private static BPELException validatorException = null;

	static {
		try {
			validator = new BPELValidator();
		} catch (final BPELException e) {
			validatorException = e;
		}
	}

	public static BPELValidator getValidator() throws BPELException {
		if (validatorException != null) {
			throw validatorException;
		}
		return validator;
	}

	/**
	 * @param args
	 */
	public static void main(final String[] args) {

		if (args.length == 1) {
			if (args[0].equals("-h") || args[0].equals("-help")) {
				Main.printHelp();
			} else {
				try {
					URL url = null;
					final File f = new File(args[0]);
					if (f.exists()) {
						System.out.println("\nload file : " + f + "\n");
						url = f.toURL();
					} else {
						System.out.println("\nload url : " + args[0] + "\n");
						url = new URL(args[0]);
					}

					System.out.println("\nValidation of BPEL file at: " + url
							+ "\n");
					final ValidatorResult result = Main.getValidator().validate(url);

					if (result.getErrors().size() > 0) {
						System.out.println("Validation errors ...");
						System.out.println(ValidatorResultPrinter.getInstance()
								.printAll(result));
					} else if (result.getWarnings().size() > 0) {
						System.out
						.println("Validation Successfully Completed with Warnings!!!");
						System.out.println(ValidatorResultPrinter.getInstance()
								.printAll(result));

					} else {
						System.out
						.println("Validation Successfully Completed ! Congratulations !");
					}

				} catch (final MalformedURLException e) {
					System.err
					.println("Impossible to find bpel file at this url: "
							+ args[0]);
					e.printStackTrace();
				} catch (final BPELException e) {
					System.err.println("Internal BPELError: " + e.getMessage());
					e.printStackTrace();
				}
			}

		} else {
			String cmd = "";
			for (final String arg : args) {
				cmd = cmd + " " + arg;
			}
			System.err.println("Bad number or invalid arguments: " + cmd);
			Main.printHelp();
		}

	}

	private static void printHelp() {
		System.out.println("Put:");
		System.out
		.println("\tfor help:               java -jar bpel-validator-tool.jar -h ");
		System.out
		.println("\tfor validate bpel file: java -jar bpel-validator-tool.jar \"bpel URI\"");
	}

}
