/**
 * easy BPEL software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import java.util.ArrayList;
import java.util.List;

public class ValidatorResult {

	public List<XPathError> errors = new ArrayList<XPathError>();

	public List<XPathWarning> warnings = new ArrayList<XPathWarning>();

	public List<XPathInfo> infos = new ArrayList<XPathInfo>();

	public void addError(final XPathError e) {
		this.errors.add(e);
	}

	public List<XPathError> getErrors() {
		return this.errors;
	}

	public void addWarning(final XPathWarning warn) {
		this.warnings.add(warn);
	}

	public List<XPathWarning> getWarnings() {
		return this.warnings;
	}

	public void addInfos(final XPathInfo info) {
		this.infos.add(info);
	}

	public List<XPathInfo> getInfos() {
		return this.infos;
	}

}
