/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELValidator;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResultPrinter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class Main {
    private static BPELValidator validator = null;
    private static BPELException validatorException = null;

    public static BPELValidator getValidator() throws BPELException {
        if (validatorException != null) {
            throw validatorException;
        }
        return validator;
    }

    public static void main(String[] args) {
        block12: {
            if (args.length == 1) {
                if (args[0].equals("-h") || args[0].equals("-help")) {
                    Main.printHelp();
                } else {
                    try {
                        URL url = null;
                        File f = new File(args[0]);
                        if (f.exists()) {
                            System.out.println("\nload file : " + f + "\n");
                            url = f.toURL();
                        } else {
                            System.out.println("\nload url : " + args[0] + "\n");
                            url = new URL(args[0]);
                        }
                        System.out.println("\nValidation of BPEL file at: " + url + "\n");
                        ValidatorResult result = Main.getValidator().validate(url);
                        if (result.getErrors().size() > 0) {
                            System.out.println("Validation errors ...");
                            System.out.println(ValidatorResultPrinter.getInstance().printAll(result));
                            break block12;
                        }
                        if (result.getWarnings().size() > 0) {
                            System.out.println("Validation Successfully Completed with Warnings!!!");
                            System.out.println(ValidatorResultPrinter.getInstance().printAll(result));
                            break block12;
                        }
                        System.out.println("Validation Successfully Completed ! Congratulations !");
                    }
                    catch (MalformedURLException e) {
                        System.err.println("Impossible to find bpel file at this url: " + args[0]);
                        e.printStackTrace();
                    }
                    catch (BPELException e) {
                        System.err.println("Internal BPELError: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            } else {
                String cmd = "";
                for (String arg : args) {
                    cmd = cmd + " " + arg;
                }
                System.err.println("Bad number or invalid arguments: " + cmd);
                Main.printHelp();
            }
        }
    }

    private static void printHelp() {
        System.out.println("Put:");
        System.out.println("\tfor help:               java -jar bpel-validator-tool.jar -h ");
        System.out.println("\tfor validate bpel file: java -jar bpel-validator-tool.jar \"bpel URI\"");
    }

    static {
        try {
            validator = new BPELValidator();
        }
        catch (BPELException e) {
            validatorException = e;
        }
    }
}

