/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELError;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELInfo;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.BPELWarning;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.URLUtil;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathError;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathInfo;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.XPathWarning;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.function.DoXslTransformFunctionImpl;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Error;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Info;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Warning;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class BPELValidator {
    private static BPELReader reader = null;
    private static BPELException readerEx = null;
    private final DocumentBuilderFactory factory;

    public static BPELReader getBPELReader() throws BPELException {
        if (readerEx != null) {
            throw readerEx;
        }
        return reader;
    }

    public BPELValidator() throws BPELException {
        BPELValidator.getBPELReader();
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
    }

    public ValidatorResult validate(URL bpel) {
        ValidatorResult res = new ValidatorResult();
        try {
            BPELStaticAnalysisImpl.getInstance().getErrors().clear();
            BPELStaticAnalysisImpl.getInstance().getWarnings().clear();
            BPELStaticAnalysisImpl.getInstance().getInfos().clear();
            URI bpelURI = URLUtil.urlToUri((URL)bpel);
            InputStream is = bpel.openStream();
            Document bpelSrcDoc = this.factory.newDocumentBuilder().parse(is);
            Document bpeltargetDoc = DoXslTransformFunctionImpl.process((URL)Thread.currentThread().getContextClassLoader().getResource("xslt/upperYesAndNoAttribute.xsl"), (Document)bpelSrcDoc, null);
            if (bpeltargetDoc.getDocumentURI() == null) {
                bpeltargetDoc.setDocumentURI(bpelURI.toString());
            }
            BPELValidator.getBPELReader().readBPEL(bpeltargetDoc);
            for (Error e : BPELStaticAnalysisImpl.getInstance().getErrors()) {
                res.getErrors().add(new XPathError((BPELError)e));
            }
            for (Warning w : BPELStaticAnalysisImpl.getInstance().getWarnings()) {
                res.getWarnings().add(new XPathWarning((BPELWarning)w));
            }
            for (Info i : BPELStaticAnalysisImpl.getInstance().getInfos()) {
                res.getInfos().add(new XPathInfo((BPELInfo)i));
            }
        }
        catch (BPELException e) {
            res.getErrors().add(new XPathError(null, e));
            e.printStackTrace();
        }
        catch (IOException e) {
            res.getErrors().add(new XPathError(null, new BPELException((Throwable)e)));
            e.printStackTrace();
        }
        catch (SAXException e) {
            res.getErrors().add(new XPathError(null, new BPELException((Throwable)e)));
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            res.getErrors().add(new XPathError(null, new BPELException((Throwable)e)));
            e.printStackTrace();
        }
        catch (XPathExpressionException e) {
            res.getErrors().add(new XPathError(null, new BPELException((Throwable)e)));
            e.printStackTrace();
        }
        return res;
    }

    static {
        try {
            reader = BPELFactoryImpl.getInstance().newBPELReader();
        }
        catch (BPELException e) {
            readerEx = e;
        }
    }
}

