/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.model.bpel.tools.validator.test.examples.all;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.AnalysorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELAnalyser;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELValidator;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResultPrinter;
import com.ebmwebsourcing.easyviper.environment.test.CoreParentTest;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;

public class AllValidationTest
extends CoreParentTest {
    public AllValidationTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAll() throws BPELException, MalformedURLException, URISyntaxException {
        BPELValidator bPELValidator = new BPELValidator();
        ValidatorResult validatorResult = bPELValidator.validate(Thread.currentThread().getContextClassLoader().getResource("com/ebmwebsourcing/easybpel/model/bpel/tools/validator/test/examples/all/Hello.bpel"));
        System.out.println(ValidatorResultPrinter.getInstance().printAll(validatorResult));
        System.out.println("XPath Links:");
        System.out.println(ValidatorResultPrinter.getInstance().printAllXPathExpression(validatorResult));
        List list = validatorResult.getInfos();
        List list2 = validatorResult.getWarnings();
        List list3 = validatorResult.getErrors();
        AllValidationTest.assertEquals((int)25, (int)list.size());
        AllValidationTest.assertEquals((int)3, (int)list2.size());
        AllValidationTest.assertEquals((int)78, (int)list3.size());
    }

    public void testAnalyzer() throws BPELException, MalformedURLException, URISyntaxException {
        BPELAnalyser bPELAnalyser = new BPELAnalyser();
        AnalysorResult analysorResult = bPELAnalyser.analyze(Thread.currentThread().getContextClassLoader().getResource("com/ebmwebsourcing/easybpel/model/bpel/tools/validator/test/examples/all/Hello.bpel"));
        System.out.println("Imports: " + analysorResult.getImports());
        System.out.println("Process Description: " + analysorResult.getProcessDescriptions());
        BPELProcess bPELProcess = analysorResult.getProcessDefinition();
        System.out.println("first Activity: " + bPELProcess.getActivity());
        if (bPELProcess.getActivity() instanceof Sequence) {
            Sequence sequence = (Sequence)bPELProcess.getActivity();
            System.out.println("number of under child activities in sequence: " + sequence.getActivities().size());
            AllValidationTest.assertEquals((int)29, (int)sequence.getActivities().size());
        } else {
            AllValidationTest.fail();
        }
    }
}

