/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation;

import java.util.List;

import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription.WSDLVersionConstants;

import com.ebmwebsourcing.easybpel.model.bpel.XMLConstants;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public interface StaticAnalysis {

	public static final String SA0013 = "The value of the \"importType\" attribute of element <import> MUST be set to "
			+ XMLConstants.W3C_XML_SCHEMA_NS_URI
			+ "\" when importing XML Schema 1.0 documents, and to \""
			+ WSDLVersionConstants.WSDL11
			+ "\" or \""
			+ WSDLVersionConstants.WSDL20
			+ "\" when importing WSDL 1.1 or 2.0 documents\n";
	
	
	
	void addError(Error e);
	
	List<Error> getErrors();
	
	void addWarning(Warning warn);
	
	List<Warning> getWarnings();
	
	void addInfo(Info info);
	
	List<Info> getInfos();
	
}
