/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports;

import java.util.List;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.extensions.wsdl4bpel.api.Description;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.impl.wsdl11.MessageImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public interface Descriptions extends Description {
	
	List<Import> getBPELImports();

	List<AbsItfInterfaceType> getProcessInterfaces() throws WSDL4BPELException;
	
	List<Schema> getSchemas();
	
	MessageImpl getMessage(QName name);
	
	PartnerLinkType getPartnerLinkType(QName plt) throws WSDL4BPELException;
	
	AbsItfDescription getDescriptionByService(QName service);
	
	AbsItfDescription getDescriptionByInterface(QName itf);
	
	AbsItfDescription getDescriptionByProperty(QName propertyName) throws WSDL4BPELException;
	
	List<org.ow2.easywsdl.schema.api.Element> findElementsInAllSchema(QName element);
	
	List<org.ow2.easywsdl.schema.api.Type> findTypesInAllSchema(QName type);
	
	 Endpoint findEndpoint(String endpointName);
}
