/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.BPELFactory;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtensionActivity;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Sources;
import com.ebmwebsourcing.easybpel.model.bpel.api.containers.Targets;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.FaultHandlers;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELWriter;
import com.ebmwebsourcing.easybpel.model.bpel.api.inout.BPELReader.FeatureConstants;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.extension.ExtensionActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.correlation.CorrelationSetImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.fault.FaultHandlersImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.partnerLink.PartnerLinkImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.wsdlImports.DescriptionsImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.wsdlImports.ImportImpl;



/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class BPELProcessImpl extends BPELElementImpl<TProcess> implements BPELProcess {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(BPELProcessImpl.class.getName());

	private final URI baseURI;

	private static BPELWriter writer = null;
	private static BPELException writerEx = null;

	private static BPELReader reader = null;

	private static BPELException readerEx = null;

	static {
		BPELFactory factory = null;
		try {
			factory = BPELFactory.newInstance();
		} catch (final BPELException e) {
			writerEx = e;
			readerEx = e;
		}

		if(factory != null) {
			try {
				writer = factory.newBPELWriter();
			} catch (final BPELException e) {
				writerEx = e;
			}

			try {
				reader = factory.newBPELReader();
			} catch (final BPELException e) {
				readerEx = e;
			}
		}
	}

	public static BPELWriter getWriter() throws BPELException {
		if(writerEx != null) {
			throw writerEx;
		}
		return writer;
	}


	public static BPELReader getReader()  throws BPELException {
		if(readerEx != null) {
			throw readerEx;
		}
		return reader;
	}

	/**
	 * the namespace context
	 */
	protected NamespaceMapperImpl namespaceContext;


	private final Descriptions descriptions;

	private Activity activity;

	private ExtensionActivity extensionActivity;

	private final List<BPELVariable> variables = new ArrayList<BPELVariable>();

	private final List<PartnerLink> partnerLinks = new ArrayList<PartnerLink>();

	private final List<CorrelationSet> correlationsets = new ArrayList<CorrelationSet>();

	private FaultHandlers faultHandlers = null;


	@SuppressWarnings("unchecked")
	public BPELProcessImpl(final URI baseURI, final TProcess process, final NamespaceMapperImpl context,
			final Map<FeatureConstants, Object> features)  {
		super(Constants._Process_QNAME, process, null);
		this.baseURI = baseURI;

		// create writer
		try {
			BPELProcessImpl.getWriter();
		} catch (final BPELException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("In process " + this.getName() + " => " + e.getMessage(),e)));
		}

		// create reader
		try {
			BPELProcessImpl.getReader();
		} catch (final BPELException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("In process " + this.getName() + " => " + e.getMessage(),e)));
		}

		this.namespaceContext = context;

		// get imports
		final List<Import> imports = new ArrayList<Import>();
		if((this.model.getImport() != null)&&(this.model.getImport().size() > 0)) {
			for(final TImport impt: this.model.getImport()) {
				imports.add(new ImportImpl(impt, this));
			}
		}
		this.descriptions = new DescriptionsImpl(this.model.getTargetNamespace(), this.model.getName(), imports);


		// get partnerLinks
		if(this.model.getPartnerLinks() != null) {
			if((this.model.getPartnerLinks().getPartnerLink() != null)&&
					(this.model.getPartnerLinks().getPartnerLink().size() > 0)) {
				for(final TPartnerLink partner: this.model.getPartnerLinks().getPartnerLink()) {
					this.partnerLinks.add(new PartnerLinkImpl(partner, this.model.getPartnerLinks(), this));
				}
			}
		}
		((DescriptionsImpl)this.descriptions).setPartnerLink(this.partnerLinks);

		// get variables
		try {
			this.variables.addAll(BPELVariableImpl.extractVariablesInModel(this.model.getVariables(), this));
		} catch (final BPELException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("In process " + this.getName() + " => " + e.getMessage(),e)));
		}

		// get correlation set
		try {
			this.correlationsets.addAll(CorrelationSetImpl.extractCorrelationSetsInModel(this.model.getCorrelationSets(), this));
		} catch (final BPELException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("In process " + this.getName() + " => " + e.getMessage(),e)));
		}

		// get activity
		try {
			this.activity = ActivityImpl.analyzeProcess(this.model, this);
		} catch (final BPELException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("In process " + this.getName() + " => " + e.getMessage(),e)));
		} 

		// get extension activity
		if(this.model.getExtensionActivity() != null) {
			this.extensionActivity = new ExtensionActivityImpl(this.model.getExtensionActivity(), this);
		}

		// get faultHandlers
		if(this.model.getFaultHandlers() != null) {
			this.faultHandlers = new FaultHandlersImpl(this.model.getFaultHandlers(), this);
		}

	}


	public URI getDocumentBaseURI() {
		URI res = null;
		if (this.baseURI.getPath().lastIndexOf("/") != -1) {
			if(this.baseURI.isAbsolute()) {
				try {
					res = new URI(
							this.baseURI.toURL().getProtocol(), this.baseURI.toURL().getUserInfo(),
							this.baseURI.toURL().getHost(), this.baseURI.toURL().getPort(),
							this.baseURI.getPath().substring(0,
									this.baseURI.getPath().lastIndexOf("/") + 1), null, this.baseURI.toURL().getRef());
				} catch (final MalformedURLException e) {
					log.warning(e.getMessage());
				} catch (final URISyntaxException e) {
					log.warning(e.getMessage());
				}
			} else {
				res = URI.create(this.baseURI.getPath().substring(0,
						this.baseURI.getPath().lastIndexOf("/") + 1));
			}
		}
		return res;
	}

	public String getName() {
		return this.model.getName();
	}

	public void setName(final String name) {
		this.model.setName(name);
	}

	public String getDescription() {
		String res = null;
		try {
			res = BPELProcessImpl.getWriter().writeBPEL(this);
		} catch (final BPELException e) {
			// do nothing
		}
		return res;
	}


	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new XmlException("Not yet implemented");
	}


	@Override
	public Map<QName, String> getOtherAttributes() throws XmlException {
		return this.model.getOtherAttributes();
	}


	public Activity getActivity() {
		return this.activity;
	}


	public Descriptions getImports() {
		return this.descriptions;
	}

	public ExtensionActivity getExtensionActivity() {
		return this.extensionActivity;
	}


	public QName getQName() {
		QName res = null; 
		if(this.model.getName() != null) {
			res = new QName(this.model.getTargetNamespace(), this.model.getName());
		}
		return res;
	}


	public Sources getSources() {
		return null;
	}


	public boolean getSuppressJoinFailure() {
		return false;
	}


	public Targets getTargets() {
		return null;
	}

	public void addVariable(final BPELVariable variable) {
		this.variables.add(variable);
	}

	public List<BPELVariable> getVariables() {
		return this.variables;
	}

	public NamespaceMapperImpl getNamespaceContext() {
		return this.namespaceContext;
	}

	public PartnerLink getPartnerLink(final String name) {
		PartnerLink res = null;
		for(final PartnerLink partner: this.partnerLinks) {
			if(partner.getName().equals(name)) {
				res = partner;
				break;
			}
		}
		return res;
	}

	public List<PartnerLink> getPartnerLinks() {
		return this.partnerLinks;
	}

	public CorrelationSet getCorrelationSet(final String name) {
		CorrelationSet res = null;
		for(final CorrelationSet corr: this.correlationsets) {
			if(corr.getName().equals(name)) {
				res = corr;
				break;
			}
		}
		return res;
	}

	public List<CorrelationSet> getCorrelationSets() {
		return this.correlationsets;
	}

	public FaultHandlers getFaultHandlers() {
		return this.faultHandlers;
	}


	public BPELVariable findVariable(final QName name) {
		BPELVariable res = null;
		if((this.variables != null) && (name != null)) {
			for(final BPELVariable var: this.variables) {
				if((var.getQName() != null) && var.getQName().equals(name)) {
					res = var;
					break;
				}
			}
		}
		if(res == null) {
			res = ScopeImpl.findVariableRecursively(name, (BPELElement) this.getParent());
		}
		return res;
	}

	public PartnerLink findPartnerLink(final String name) {
		PartnerLink res = null;
		for(final PartnerLink p: this.partnerLinks) {
			if(p.getName().equals(name)) {
				res = p;
				break;
			}
		}
		return res;
	}


	public String getTargetNamespace() {
		return this.model.getTargetNamespace();
	}


	public void setTargetNamespace(final String ns) {
		this.model.setTargetNamespace(ns);
	}

}
