/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.Catch;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.CatchAll;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCatch;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCorrelation;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInvoke;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.correlation.CorrelationImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.fault.CatchAllImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.fault.CatchImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class InvokeImpl extends ActivityImpl<TInvoke> implements Invoke {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final List<Correlation> correlations = new ArrayList<Correlation>();

	private final List<Catch> catchs = new ArrayList<Catch>();

	private CatchAll catchAll = null;

	public InvokeImpl(final TInvoke model, final BPELElement parent) {
		super(Constants._Invoke_QNAME, model, parent);

		if(this.getInterface() != null) {
			if((this.getInterface().getNamespaceURI() == null) || this.getInterface().getNamespaceURI().equals("")) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("In invoke " + this.getName() + ": this interface \"" + this.getInterface() + "\" is not associated to a namespace ")));
			}
		}

		// get all correlations
		if(this.model.getCorrelations() != null) {
			for(final TCorrelation corr: this.model.getCorrelations().getCorrelation()) {
				this.correlations.add(new CorrelationImpl(corr, this.model.getCorrelations(), this)); 
			}
		}

		// get all catchs
		if(this.model.getCatch() != null) {
			for(final TCatch catch_: this.model.getCatch()) {
				this.catchs.add(new CatchImpl(catch_, this)); 
			}
		}

		// get catchAll
		if(this.model.getCatchAll() != null) {
			this.catchAll = new CatchAllImpl(this.model.getCatchAll(), this); 
		}
	}


	public String getInputVariable() {
		return this.model.getInputVariable();
	}




	public QName getInterface() {
		return this.model.getPortType();
	}




	public String getOutputVariable() {
		return this.model.getOutputVariable();
	}




	public String getPartnerLink() {
		return this.model.getPartnerLink();
	}




	public String getOperation() {
		return this.model.getOperation();
	}


	public List<Correlation> getCorrelations() {
		return this.correlations;
	}

	public List<Catch> getCatchs() {
		return this.catchs;
	}


	public CatchAll getCatchAll() {
		return this.catchAll;
	}


}
