/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.DefaultSchemaImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.ForEach;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.api.fault.FaultHandlers;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TScope;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariable;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TVariables;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.correlation.CorrelationSetImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.fault.FaultHandlersImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.partnerLink.PartnerLinkImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELIntVariableImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.variable.BPELVariableImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ScopeImpl extends ActivityImpl<TScope> implements Scope {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final List<BPELVariable> variables = new ArrayList<BPELVariable>();

	private final List<PartnerLink> partnerLinks = new ArrayList<PartnerLink>();

	private final List<CorrelationSet> correlationsets = new ArrayList<CorrelationSet>();

	private FaultHandlers faultHandlers = null;

	private Activity activity;

	public ScopeImpl(final TScope model, final BPELElement parent) {
		super(Constants._Scope_QNAME, model, parent);

		// get partnerLinks
		if(this.model.getPartnerLinks() != null) {
			if((this.model.getPartnerLinks().getPartnerLink() != null)&&
					(this.model.getPartnerLinks().getPartnerLink().size() > 0)) {
				for(final TPartnerLink partner: this.model.getPartnerLinks().getPartnerLink()) {
					this.partnerLinks.add(new PartnerLinkImpl(partner, this.model.getPartnerLinks(), this));
				}
			}
		}

		// get variables
		try {
			this.variables.addAll(BPELVariableImpl.extractVariablesInModel(this.model.getVariables(), this));
		} catch (final BPELException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("In scope " + this.getName() + " => " + e.getMessage(), e)));
		}


		// get correlation set
		try {
			this.correlationsets.addAll(CorrelationSetImpl.extractCorrelationSetsInModel(this.model.getCorrelationSets(), this));
		} catch (final BPELException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("In scope " + this.getName() + " => " + e.getMessage(), e)));
		}


		// get activity
		try {
			this.activity = ActivityImpl.analyzeScope(model, this);
		} catch (final BPELException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("In scope " + this.getName() + " => " + e.getMessage(), e)));
		} 

		// get faultHandlers
		if(this.model.getFaultHandlers() != null) {
			this.faultHandlers = new FaultHandlersImpl(this.model.getFaultHandlers(), this);
		}
	}





	public void addVariable(final BPELVariable variable) {
		this.variables.add(variable);
	}


	public List<BPELVariable> getVariables() {
		return this.variables;
	}



	public Activity getActivity() {
		return this.activity;
	}


	public PartnerLink getPartnerLink(final String name) {
		PartnerLink res = null;
		for(final PartnerLink partner: this.partnerLinks) {
			if(partner.getName().equals(name)) {
				res = partner;
				break;
			}
		}
		return res;
	}

	public List<PartnerLink> getPartnerLinks() {
		return this.partnerLinks;
	}

	public CorrelationSet getCorrelationSet(final String name) {
		CorrelationSet res = null;
		for(final CorrelationSet corr: this.correlationsets) {
			if(corr.getName().equals(name)) {
				res = corr;
				break;
			}
		}
		return res;
	}

	public List<CorrelationSet> getCorrelationSets() {
		return this.correlationsets;
	}





	public FaultHandlers getFaultHandlers() {
		return this.faultHandlers;
	}


	public BPELVariable findVariable(final QName name) {
		BPELVariable res = null;
		if((this.variables != null) && (name != null)) {
			for(final BPELVariable var: this.variables) {
				if((var.getQName() != null) && var.getQName().equals(name)) {
					res = var;
					break;
				}
			}
		}
		if(res == null) {
			res = ScopeImpl.findVariableRecursively(name, (BPELElement) this.getParent());
		}
		return res;
	}


	public static BPELVariable findVariableRecursively(final QName name, final BPELElement parent) {
		BPELVariable res = null;
		if((name != null) && (parent != null)) {
			if(parent instanceof BPELProcess) {
				res = ((BPELProcess)parent).findVariable(name); 
			} else if(parent instanceof Scope) {
				res = ((Scope)parent).findVariable(name); 
			} else if(parent instanceof ForEach) {
				final ForEach forEach = (ForEach)parent;
				
				if(forEach.getCounterName().equals(name.getLocalPart())) {
					final TVariable tvar = new TVariable();
					tvar.setName(name.getLocalPart());
					tvar.setType(DefaultSchemaImpl.getInstance().getTypeInt().getQName());
					final TVariables tvars = new TVariables();
					tvars.getVariable().add(tvar);
					final BPELVariable<Integer> var = new BPELIntVariableImpl(tvar, tvars, parent);
					res = var;
				}
			}
			if(res == null) {
				res = ScopeImpl.findVariableRecursively(name, (BPELElement) ((AbstractSchemaElementImpl)parent).getParent()); 
			}
		}
		return res;
	}

	public static PartnerLink findPartnerLinkRecursively(final String name, final BPELElement parent) {
		PartnerLink res = null;
		final Scope parentScope = ScopeImpl.getParentScope(parent);
		if(parentScope != null) {
			res  = parentScope.findPartnerLink(name);
		}
		if(res == null) {
			final BPELProcess process = ScopeImpl.getProcess(parent);
			res = process.findPartnerLink(name); 
		}
		return res;
	}


	public static BPELProcess getProcess(final BPELElement parent) {
		BPELProcess res = null;
		if(parent != null) {
			if(parent instanceof BPELProcess) {
				res = (BPELProcess) parent;
			} else {
				res = ScopeImpl.getProcess((BPELElement) ((AbstractSchemaElementImpl)parent).getParent());
			}
		}
		return res;
	}





	public static Scope getParentScope(final BPELElement child) {
		Scope res = null;
		if(child != null) {
			final BPELElement parent = (BPELElement) ((AbstractSchemaElementImpl)child).getParent();
			if(parent != null) {
				if(parent instanceof Scope) {
					res = (Scope) parent;
				} else {
					res = ScopeImpl.getParentScope(parent);
				}
			}
		}
		return res;
	}





	public PartnerLink findPartnerLink(final String name) {
		PartnerLink res = null;
		for(final PartnerLink p: this.partnerLinks) {
			if(p.getName().equals(name)) {
				res = p;
				break;
			}
		}
		return res;
	}

}
