/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Wait;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.BPELDeadLineExpression;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.BPELDurationExpression;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWait;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.BPELDeadLineExpressionImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.expression.BPELDurationExpressionImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WaitImpl extends ActivityImpl<TWait> implements Wait {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private BPELDurationExpression duration;
	
	private BPELDeadLineExpression date;

	public WaitImpl(final TWait model, final BPELElement parent) {
		super(Constants._Wait_QNAME, model, parent);
		
		if(this.model.getFor() != null) {
			this.duration = new BPELDurationExpressionImpl(this.model.getFor(), this);
		}
		
		if(this.model.getUntil() != null) {
			this.date = new BPELDeadLineExpressionImpl(this.model.getUntil(), this);
		}
	}


	public BPELDurationExpression getFor() {
		return this.duration;
	}


	public BPELDeadLineExpression getUntil() {
		return this.date;
	}

}
