/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign;

import java.util.List;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBoolean;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCopy;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;


public class CopyImpl extends BPELElementImpl<TCopy> implements Copy {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	//private Logger log = Logger.getLogger(CopyImpl.class.getName());


	private From from;

	private To to;

	@SuppressWarnings("unchecked")
	public CopyImpl(final TCopy model, final BPELElementImpl parent) {
		super(Constants._Copy_QNAME, model, parent);
		if(this.model.getFrom() != null) {
			this.from = new FromImpl(this.model.getFrom(), this);
		}
		if(this.model.getTo() != null) {
			this.to = new ToImpl(this.model.getTo(), this);
		}
	}

	public From getFrom() {
		return this.from;
	}

	public To getTo() {
		return this.to;
	}

	public void setFrom(final From from) {
		this.from = from;
	}

	public void setTo(final To to) {
		this.to = to;
	}


	public boolean getIgnoreMissingFromData() {
		return Boolean.valueOf(this.model.getIgnoreMissingFromData().value);
	}

	public boolean getKeepSrcElementName() {
		return Boolean.valueOf(this.model.getKeepSrcElementName().value);
	}



	public void setIgnoreMissingFromData(final boolean ignore) {
		if(ignore) {
			this.model.setIgnoreMissingFromData(TBoolean.YES);
		} else {
			this.model.setIgnoreMissingFromData(TBoolean.NO);
		}
	}

	public void setKeepSrcElementName(final boolean keep) {
		if(keep) {
			this.model.setKeepSrcElementName(TBoolean.YES);
		} else {
			this.model.setKeepSrcElementName(TBoolean.NO);
		}

	}

	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

}
