/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign;

import java.util.List;

import javax.xml.bind.JAXBElement;

import org.jdom.input.DOMBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Literal;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.ServiceRef;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TLiteral;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.partnerLink.ServiceRefImpl;
import com.ebmwebsourcing.easybpel.model.bpel.serviceref.ServiceRefType;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class LiteralImpl extends BPELElementImpl<TLiteral> implements Literal {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@SuppressWarnings("unchecked")
	public LiteralImpl(final TLiteral model, final BPELElementImpl parent) {
		super(Constants._Literal_QNAME, model, parent);
	}

	public String getStringContent() {
		String content = null;
		if(this.model.getContent().size() > 0) {
			if(this.model.getContent().get(0) instanceof String) {
				content = (String) this.model.getContent().get(0);
			} 
		}
		return content;
	}

	public org.jdom.Element getElementContent() {
		org.jdom.Element content = null;
		if(this.model.getContent().size() > 0) {
			for(final Object obj: this.model.getContent()) {
				if((obj instanceof JAXBElement)&&
						(((JAXBElement)obj).getValue() instanceof ServiceRefType)) {
					final ServiceRef sref = new ServiceRefImpl((ServiceRefType) ((JAXBElement)obj).getValue(), this);
					content = sref.toElement();
					break;
				}  else if (obj instanceof Element) {
					final Element elmt = (Element)obj;
					final DOMBuilder builder = new DOMBuilder();
					final org.jdom.Document jdomDocument = builder.build(elmt.getOwnerDocument());

					content = jdomDocument.getRootElement();
					break;
				}
			}
		}
		return content;
	}

	public void setContent(final String content) {
		if(this.model.getContent().size() > 0) {
			this.model.getContent().remove(0);
			this.model.getContent().add(0, content);
		} else {
			final TLiteral item = new TLiteral();
			item.getContent().add(content);
			this.model.getContent().add(item);
		}
	}

	public void setContent(final Element content) {
		if(this.model.getContent().size() > 0) {
			this.model.getContent().remove(0);
			this.model.getContent().add(0, content);
		} else {
			final TLiteral item = new TLiteral();
			item.getContent().add(content);
			this.model.getContent().add(item);
		}
	}

	@Override
	public List<Element> getOtherElements() throws XmlException {
		return null;
	}

	@Override
	public String toString() {
		String res = null;
		res  = this.getStringContent();
		if((res == null)&&(this.getElementContent() != null)) {
			res = new XMLOutputter(Format.getPrettyFormat()).outputString(this.getElementContent());
		}
		return res;
	}
	

}