/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4pick;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.Constants;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.Correlation;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCorrelation;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ActivityImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.correlation.CorrelationImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class OnMessageImpl extends BPELElementImpl<TOnMessage> implements OnMessage {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Activity activity;

	/**
	 * DO NOT INITIALIZE THIS LIST
	 */
	private List<Correlation> correlations = null;

	public OnMessageImpl(final TOnMessage model, final BPELElementImpl parent) {
		super(Constants._OnMessage_QNAME, model, parent);

		if(this.model.getCorrelations() != null) {
			this.correlations = new ArrayList<Correlation>();
			for(final TCorrelation corr: this.model.getCorrelations().getCorrelation()) {
				this.correlations.add(new CorrelationImpl(corr, this.model.getCorrelations(), this)); 
			}
		}
		try {
			this.activity = ActivityImpl.analyzeOnMessageActivity(this.model, this);
		} catch (final BPELException e) {
			final Pick pick = (Pick) this.getParent();
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this, new BPELException("In one onMessage of pick " + pick.getName() + " => " + e.getMessage(), e)));
		}
	}



	public String getInputVariable() {
		return this.model.getVariable();
	}

	public QName getInterface() {
		return this.model.getPortType();
	}

	public String getMessageExchange() {
		return this.model.getMessageExchange();
	}

	public String getOperation() {
		return this.model.getOperation();
	}

	public String getPartnerLink() {
		return this.model.getPartnerLink();
	}



	@Override
	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}



	public Activity getActivity() {
		return this.activity;
	}


	public List<Correlation> getCorrelations() {
		return this.correlations;
	}


}
