/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.Error;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.Info;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.Warning;

public class StaticAnalysisPrinter {


	private static StaticAnalysisPrinter instance = null;

	public static StaticAnalysisPrinter getInstance() {
		if(instance == null) {
			instance = new StaticAnalysisPrinter();
		}
		return instance;
	}
	
	public List<String> printErrorsAsString(final List<Error> errors) {
		final List<String> res = new ArrayList<String>();
		for(final Error e: errors) {
			res.add(e.getError().getMessage());
		}
		return res;
	}
	

	public String printAllErrors(final List<Error> errors) {
		String res = "";
		for(final String s: this.printErrorsAsString(errors)) {
			res = res + s + "\n";
		}
		return res;
	}

	public String printAllWarnings(final List<Warning> warnings) {
		String res = "";
		for(final Warning w: warnings) {
			res = res + w.getWarning() + "\n";
		}
		return res;
	}
	
	public String printAllInfos(final List<Info> infos) {
		String res = "";
		for(final Info i: infos) {
			res = res + i.getInfo() + "\n";
		}
		return res;
	}
	
	public String printAll(final List<Error> errors, final List<Warning> warnings, final List<Info> infos) {
		String res = "";
		if((infos != null) && (infos.size() > 0)) {
			res = res + infos.size() + " Infos:\n" + this.printAllInfos(infos);
		}
		if(res.length() > 0) {
			res = res + "\n";
		}
		if((warnings != null) && (warnings.size() > 0)) {
			res = res + warnings.size() + " Warnings:\n" + this.printAllWarnings(warnings);
		}
		if(res.length() > 0) {
			res = res + "\n";
		}
		if((errors != null) && (errors.size() > 0)) {
			res = res + errors.size() + " Errors:\n" + this.printAllErrors(errors);
		}
		return res;
	}

}
