/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.extensions.wsdl4bpel.api.Property;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.CorrelationSetValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.correlation.CorrelationSet;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ScopeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;

public class CorrelationSetValidatorImpl implements CorrelationSetValidator {

	private CorrelationSet correlationSet = null;

	public CorrelationSetValidatorImpl(final CorrelationSet correlationSet) {
		this.correlationSet = correlationSet;
	}

	public void validate() {
		// validation
		try {
			// validation if null or empty
			if((this.correlationSet.getName() == null) || (this.correlationSet.getName().trim().length() == 0)) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.correlationSet, new BPELException("In CorrelationSet => The name cannot be null or empty")));
			}
			if((this.correlationSet.getProperties() == null) || (this.correlationSet.getProperties().size() == 0)) {
				StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.correlationSet, new BPELException("In CorrelationSet => The properties cannot be null or empty")));
			}

			//validation on content
			final BPELProcess process = ScopeImpl.getProcess((this.correlationSet));

			if(this.correlationSet.getProperties() != null) {
				for(final QName propertyName: this.correlationSet.getProperties()) {
					final Property prop = process.getImports().getProperty(propertyName);
					if(prop == null) {
						StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.correlationSet, new BPELException("In CorrelationSet => Impossible to find property corresponding to this name " + propertyName)));
					}
				}
			}
		} catch (final WSDL4BPELException e) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.correlationSet, new BPELException("In CorrelationSet => " + e.getMessage(), e)));
		}
	}

}
