/**
* easy BPEL software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator;

import org.jdom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.compiler.validation.validator.ExpressionValidator;
import com.ebmwebsourcing.easybpel.model.bpel.api.expression.BPELExpression;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.ErrorImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.StaticAnalysisImpl;

public class ExpressionValidatorImpl implements ExpressionValidator<Element> {

	private BPELExpression<?> exp = null;

	public ExpressionValidatorImpl(final BPELExpression<?> exp) {
		this.exp = exp;
	}

	public void validate() {
		// validation

		// validation on content
		if((this.exp.getExpressionLanguage() != null) && !this.exp.getExpressionLanguage().toString().equals("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0")
				&& !this.exp.getExpressionLanguage().toString().equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.exp, new BPELException("In expressionLanguage => Unknowned uri: " + this.exp.getExpressionLanguage() + ". Only the uri " + "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0" + " and " + "http://www.w3.org/TR/1999/REC-xpath-19991116"+ " are supported")));
		}
		
//		if(this.exp.getContent() == null) {
//			StaticAnalysisImpl.getInstance().addError(new ErrorImpl(this.exp, new BPELException("In expression => the content of expression cannot be null")));
//		}

	}

}
